/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorWrapper;

public abstract class CollectionWrapper<T, U>
implements Collection<T> {
    private Collection<U> collection;

    public CollectionWrapper(Collection<U> underlyingCollection) {
        this.collection = underlyingCollection;
    }

    protected abstract U objectToUnderlyingObject(T var1);

    protected abstract T underlyingObjectToObject(U var1);

    @Override
    public boolean add(T o) {
        return this.collection.add(this.objectToUnderlyingObject(o));
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(this.objectToUnderlyingObject(o));
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new WrappingIterator(this.collection.iterator());
    }

    @Override
    public boolean remove(Object o) {
        return this.collection.remove(this.objectToUnderlyingObject(o));
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    protected Collection<U> convertCollection(Collection c) {
        HashSet<U> converted = new HashSet<U>();
        for (Object item : c) {
            converted.add(this.objectToUnderlyingObject(item));
        }
        return converted;
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.collection.retainAll(this.convertCollection(c));
    }

    @Override
    public boolean addAll(Collection c) {
        return this.collection.addAll(this.convertCollection(c));
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.collection.removeAll(this.convertCollection(c));
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.collection.containsAll(this.convertCollection(c));
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.collection.toArray();
        Object[] result = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = this.underlyingObjectToObject(array[i]);
        }
        return result;
    }

    @Override
    public <R> R[] toArray(R[] a) {
        Object[] array = this.collection.toArray();
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < array.length; ++i) {
            result.add(this.underlyingObjectToObject(array[i]));
        }
        return result.toArray(a);
    }

    private class WrappingIterator
    extends IteratorWrapper<T, U> {
        WrappingIterator(Iterator<U> iterator) {
            super(iterator);
        }

        @Override
        protected T underlyingObjectToObject(U object) {
            return CollectionWrapper.this.underlyingObjectToObject(object);
        }
    }
}

