/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.impl.api.RecoveryLegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.index.RecoveryIndexingUpdatesValidator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.StoreFlusher;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;
import org.neo4j.kernel.recovery.Recovery;

public class DefaultRecoverySPI
implements Recovery.SPI {
    private final RecoveryLabelScanWriterProvider labelScanWriters;
    private final RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup;
    private final StoreFlusher storeFlusher;
    private final NeoStores neoStores;
    private final Visitor<LogVersionedStoreChannel, IOException> logFileRecoverer;
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final LogVersionRepository logVersionRepository;
    private final PositionToRecoverFrom positionToRecoverFrom;
    private final RecoveryIndexingUpdatesValidator indexUpdatesValidator;

    public DefaultRecoverySPI(RecoveryLabelScanWriterProvider labelScanWriters, RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup, StoreFlusher storeFlusher, NeoStores neoStores, Visitor<LogVersionedStoreChannel, IOException> logFileRecoverer, PhysicalLogFiles logFiles, FileSystemAbstraction fileSystemAbstraction, LogVersionRepository logVersionRepository, LatestCheckPointFinder checkPointFinder, RecoveryIndexingUpdatesValidator indexUpdatesValidator) {
        this.labelScanWriters = labelScanWriters;
        this.legacyIndexApplierLookup = legacyIndexApplierLookup;
        this.storeFlusher = storeFlusher;
        this.neoStores = neoStores;
        this.logFileRecoverer = logFileRecoverer;
        this.logFiles = logFiles;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.logVersionRepository = logVersionRepository;
        this.indexUpdatesValidator = indexUpdatesValidator;
        this.positionToRecoverFrom = new PositionToRecoverFrom(checkPointFinder);
    }

    @Override
    public void forceEverything() {
        try {
            this.labelScanWriters.close();
            this.legacyIndexApplierLookup.close();
            this.indexUpdatesValidator.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.storeFlusher.forceEverything();
    }

    @Override
    public Visitor<LogVersionedStoreChannel, IOException> getRecoverer() {
        return this.logFileRecoverer;
    }

    @Override
    public Iterator<LogVersionedStoreChannel> getLogFiles(final long fromVersion) throws IOException {
        return new Iterator<LogVersionedStoreChannel>(){
            private long currentVersion;
            private LogVersionedStoreChannel current;
            {
                this.currentVersion = fromVersion;
                this.current = PhysicalLogFile.tryOpenForVersion(DefaultRecoverySPI.this.logFiles, DefaultRecoverySPI.this.fileSystemAbstraction, this.currentVersion);
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public LogVersionedStoreChannel next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                LogVersionedStoreChannel tmp = this.current;
                this.current = PhysicalLogFile.tryOpenForVersion(DefaultRecoverySPI.this.logFiles, DefaultRecoverySPI.this.fileSystemAbstraction, ++this.currentVersion);
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public LogPosition getPositionToRecoverFrom() throws IOException {
        return this.positionToRecoverFrom.apply(this.logVersionRepository.getCurrentLogVersion());
    }

    @Override
    public void recoveryRequired() {
        this.neoStores.deleteIdGenerators();
    }
}

