/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.function.Consumer;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.info.SystemDiagnostics;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class DiagnosticsManager
implements Iterable<DiagnosticsProvider>,
Lifecycle {
    private final List<DiagnosticsProvider> providers = new CopyOnWriteArrayList<DiagnosticsProvider>();
    private final Log targetLog;
    private volatile State state = State.INITIAL;

    public DiagnosticsManager(Log targetLog) {
        this.targetLog = targetLog;
        this.providers.add(new DiagnosticsProvider(){

            @Override
            public String getDiagnosticsIdentifier() {
                return DiagnosticsManager.this.getClass().getName();
            }

            @Override
            public void dump(DiagnosticsPhase phase, Logger logger) {
                if (phase.isInitialization() || phase.isExplicitlyRequested()) {
                    logger.log("Diagnostics providers:");
                    for (DiagnosticsProvider provider : DiagnosticsManager.this.providers) {
                        logger.log(provider.getDiagnosticsIdentifier());
                    }
                }
            }

            @Override
            public void acceptDiagnosticsVisitor(Object visitor) {
                Visitor<DiagnosticsProvider, RuntimeException> target = Visitor.SafeGenerics.castOrNull(DiagnosticsProvider.class, RuntimeException.class, visitor);
                if (target != null) {
                    for (DiagnosticsProvider provider : DiagnosticsManager.this.providers) {
                        target.visit(provider);
                    }
                }
            }
        });
        SystemDiagnostics.registerWith(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Throwable {
        List<DiagnosticsProvider> list = this.providers;
        synchronized (list) {
            State state = this.state;
            if (!state.startup(this)) {
                return;
            }
        }
        this.dumpAll(DiagnosticsPhase.INITIALIZED, this.getTargetLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        List<DiagnosticsProvider> list = this.providers;
        synchronized (list) {
            State state = this.state;
            if (!state.startup(this)) {
                return;
            }
        }
        this.dumpAll(DiagnosticsPhase.STARTED, this.getTargetLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Throwable {
        List<DiagnosticsProvider> list = this.providers;
        synchronized (list) {
            State state = this.state;
            if (!state.shutdown(this)) {
                return;
            }
        }
        this.dumpAll(DiagnosticsPhase.STOPPING, this.getTargetLog());
        this.providers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        List<DiagnosticsProvider> list = this.providers;
        synchronized (list) {
            State state = this.state;
            if (!state.shutdown(this)) {
                return;
            }
        }
        this.dumpAll(DiagnosticsPhase.SHUTDOWN, this.getTargetLog());
        this.providers.clear();
    }

    public Log getTargetLog() {
        return this.targetLog;
    }

    public void dumpAll() {
        this.dumpAll(DiagnosticsPhase.REQUESTED, this.getTargetLog());
    }

    public void dump(String identifier) {
        this.extract(identifier, this.getTargetLog());
    }

    public void dumpAll(Log log) {
        log.bulk((Consumer)new Consumer<Log>(){

            public void accept(Log bulkLog) {
                for (DiagnosticsProvider provider : DiagnosticsManager.this.providers) {
                    DiagnosticsManager.dump(provider, DiagnosticsPhase.EXPLICIT, bulkLog);
                }
            }
        });
    }

    public void extract(final String identifier, Log log) {
        log.bulk((Consumer)new Consumer<Log>(){

            public void accept(Log bulkLog) {
                for (DiagnosticsProvider provider : DiagnosticsManager.this.providers) {
                    if (!identifier.equals(provider.getDiagnosticsIdentifier())) continue;
                    DiagnosticsManager.dump(provider, DiagnosticsPhase.EXPLICIT, bulkLog);
                    return;
                }
            }
        });
    }

    private void dumpAll(final DiagnosticsPhase phase, Log log) {
        log.bulk((Consumer)new Consumer<Log>(){

            public void accept(Log bulkLog) {
                phase.emitStart(bulkLog);
                for (DiagnosticsProvider provider : DiagnosticsManager.this.providers) {
                    DiagnosticsManager.dump(provider, phase, bulkLog);
                }
                phase.emitDone(bulkLog);
            }
        });
    }

    public <T> void register(DiagnosticsExtractor<T> extractor, T source) {
        this.appendProvider(DiagnosticsManager.extractedProvider(extractor, source));
    }

    public <T, E extends Enum<E>> void registerAll(Class<E> extractorEnum, T source) {
        for (Enum extractor : (Enum[])extractorEnum.getEnumConstants()) {
            this.register((DiagnosticsExtractor<T>)((Object)extractor), source);
        }
    }

    public void prependProvider(DiagnosticsProvider provider) {
        State state = this.state;
        if (state == State.STOPPED) {
            return;
        }
        this.providers.add(0, provider);
        if (state == State.STARTED) {
            this.dump(DiagnosticsPhase.STARTED, provider, this.getTargetLog());
        }
    }

    public void appendProvider(DiagnosticsProvider provider) {
        State state = this.state;
        if (state == State.STOPPED) {
            return;
        }
        this.providers.add(provider);
        if (state == State.STARTED) {
            this.dump(DiagnosticsPhase.STARTED, provider, this.getTargetLog());
        }
    }

    private void dump(DiagnosticsPhase phase, DiagnosticsProvider provider, Log log) {
        phase.emitStart(log, provider);
        DiagnosticsManager.dump(provider, phase, log);
        phase.emitDone(log, provider);
    }

    private static void dump(DiagnosticsProvider provider, DiagnosticsPhase phase, Log log) {
        try {
            provider.dump(phase, log.infoLogger());
        }
        catch (Exception cause) {
            log.error("Failure while logging diagnostics for " + provider, (Throwable)cause);
        }
    }

    @Override
    public Iterator<DiagnosticsProvider> iterator() {
        return this.providers.iterator();
    }

    static <T> DiagnosticsProvider extractedProvider(DiagnosticsExtractor<T> extractor, T source) {
        if (extractor instanceof DiagnosticsExtractor.VisitableDiagnostics) {
            return new ExtractedVisitableDiagnosticsProvider<T>((DiagnosticsExtractor.VisitableDiagnostics)extractor, source);
        }
        return new ExtractedDiagnosticsProvider<T>(extractor, source);
    }

    private static class ExtractedVisitableDiagnosticsProvider<T>
    extends ExtractedDiagnosticsProvider<T> {
        ExtractedVisitableDiagnosticsProvider(DiagnosticsExtractor.VisitableDiagnostics<T> extractor, T source) {
            super(extractor, source);
        }

        @Override
        public void acceptDiagnosticsVisitor(Object visitor) {
            ((DiagnosticsExtractor.VisitableDiagnostics)this.extractor).dispatchDiagnosticsVisitor(this.source, visitor);
        }
    }

    private static class ExtractedDiagnosticsProvider<T>
    implements DiagnosticsProvider {
        final DiagnosticsExtractor<T> extractor;
        final T source;

        ExtractedDiagnosticsProvider(DiagnosticsExtractor<T> extractor, T source) {
            this.extractor = extractor;
            this.source = source;
        }

        @Override
        public String getDiagnosticsIdentifier() {
            return this.extractor.toString();
        }

        @Override
        public void acceptDiagnosticsVisitor(Object visitor) {
        }

        @Override
        public void dump(DiagnosticsPhase phase, Logger logger) {
            this.extractor.dumpDiagnostics(this.source, phase, logger);
        }
    }

    private static enum State {
        INITIAL{

            @Override
            boolean startup(DiagnosticsManager manager) {
                manager.state = 1.STARTED;
                return true;
            }
        }
        ,
        STARTED,
        STOPPED{

            @Override
            boolean shutdown(DiagnosticsManager manager) {
                return false;
            }
        };


        boolean startup(DiagnosticsManager manager) {
            return false;
        }

        boolean shutdown(DiagnosticsManager manager) {
            manager.state = State.STOPPED;
            return true;
        }
    }
}

