/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;

public class ReadAheadLogChannel
implements ReadableVersionableLogChannel {
    public static final int DEFAULT_READ_AHEAD_SIZE = 4096;
    private final ByteBuffer aheadBuffer;
    private LogVersionedStoreChannel channel;
    private final LogVersionBridge bridge;
    private final int readAheadSize;

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, int readAheadSize) {
        this.channel = startingChannel;
        this.bridge = bridge;
        this.readAheadSize = readAheadSize;
        this.aheadBuffer = ByteBuffer.allocate(readAheadSize);
        this.aheadBuffer.position(this.aheadBuffer.capacity());
    }

    @Override
    public long getVersion() {
        return this.channel.getVersion();
    }

    @Override
    public byte getLogFormatVersion() {
        return this.channel.getLogFormatVersion();
    }

    @Override
    public byte get() throws IOException {
        this.ensureDataExists(1);
        return this.aheadBuffer.get();
    }

    @Override
    public short getShort() throws IOException {
        this.ensureDataExists(2);
        return this.aheadBuffer.getShort();
    }

    @Override
    public int getInt() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getInt();
    }

    @Override
    public long getLong() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getLong();
    }

    @Override
    public float getFloat() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getFloat();
    }

    @Override
    public double getDouble() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws IOException {
        int chunkSize;
        assert (length <= bytes.length);
        for (int bytesGotten = 0; bytesGotten < length; bytesGotten += chunkSize) {
            chunkSize = Math.min(this.readAheadSize >> 2, length - bytesGotten);
            this.ensureDataExists(chunkSize);
            this.aheadBuffer.get(bytes, bytesGotten, chunkSize);
        }
    }

    private void ensureDataExists(int requestedNumberOfBytes) throws IOException {
        int remaining = this.aheadBuffer.remaining();
        if (remaining >= requestedNumberOfBytes) {
            return;
        }
        System.arraycopy(this.aheadBuffer.array(), this.aheadBuffer.position(), this.aheadBuffer.array(), 0, remaining);
        this.aheadBuffer.clear();
        this.aheadBuffer.position(remaining);
        while (this.aheadBuffer.position() < this.aheadBuffer.capacity()) {
            int read = this.channel.read(this.aheadBuffer);
            if (read != -1) continue;
            if (this.aheadBuffer.position() >= requestedNumberOfBytes) break;
            LogVersionedStoreChannel nextChannel = this.bridge.next(this.channel);
            assert (nextChannel != null);
            if (nextChannel == this.channel) {
                throw ReadPastEndException.INSTANCE;
            }
            this.channel = nextChannel;
        }
        this.aheadBuffer.flip();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.channel.getVersion(), this.channel.position() - (long)this.aheadBuffer.remaining());
        return positionMarker;
    }
}

