/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.neo4j.function.Function;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.AbstractRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class DumpStore<RECORD extends AbstractBaseRecord, STORE extends CommonAbstractStore> {
    private final PrintStream out;
    private final HexPrinter printer;

    public static void main(String ... args) throws Exception {
        if (args == null || args.length == 0) {
            System.err.println("SYNTAX: [file[:id[,id]*]]+");
            return;
        }
        final DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        final DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)fs);
        try (final PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);){
            Function<File, StoreFactory> createStoreFactory = new Function<File, StoreFactory>(){

                public StoreFactory apply(File file) {
                    return new StoreFactory(file.getParentFile(), new Config(), idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, DumpStore.logProvider());
                }
            };
            for (String arg : args) {
                DumpStore.dumpFile(createStoreFactory, arg);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void dumpFile(Function<File, StoreFactory> createStoreFactory, String arg) throws Exception {
        File file = new File(arg);
        long[] ids = null;
        if (!file.isFile() && !file.isDirectory() && file.getName().indexOf(58) != -1) {
            int idStart = arg.lastIndexOf(58);
            String[] idStrings = arg.substring(idStart + 1).split(",");
            ids = new long[idStrings.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = Long.parseLong(idStrings[i]);
            }
            file = new File(arg.substring(0, idStart));
            if (!file.isFile()) {
                throw new IllegalArgumentException("No such file: " + arg);
            }
        }
        try (NeoStores neoStores = ((StoreFactory)createStoreFactory.apply((Object)file)).openNeoStoresEagerly();){
            switch (file.getName()) {
                case "neostore.nodestore.db": {
                    DumpStore.dumpNodeStore(neoStores, ids);
                    return;
                }
                case "neostore.relationshipstore.db": {
                    DumpStore.dumpRelationshipStore(neoStores, ids);
                    return;
                }
                case "neostore.propertystore.db": {
                    DumpStore.dumpPropertyStore(neoStores, ids);
                    return;
                }
                case "neostore.schemastore.db": {
                    DumpStore.dumpSchemaStore(neoStores, ids);
                    return;
                }
                case "neostore.propertystore.db.index": {
                    DumpStore.dumpPropertyKeys(neoStores, ids);
                    return;
                }
                case "neostore.labeltokenstore.db": {
                    DumpStore.dumpLabels(neoStores, ids);
                    return;
                }
                case "neostore.relationshiptypestore.db": {
                    DumpStore.dumpRelationshipTypes(neoStores, ids);
                    return;
                }
                case "neostore.relationshipgroupstore.db": {
                    DumpStore.dumpRelationshipGroups(neoStores, ids);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unknown store file: " + arg);
                }
            }
        }
    }

    private static LogProvider logProvider() {
        return Boolean.getBoolean("logger") ? FormattedLogProvider.toOutputStream((OutputStream)System.out) : NullLogProvider.getInstance();
    }

    private static <R extends AbstractBaseRecord, S extends CommonAbstractStore> void dump(long[] ids, S store) throws Exception {
        new DumpStore(System.out).dump(store, ids);
    }

    private static void dumpPropertyKeys(NeoStores neoStores, long[] ids) throws Exception {
        DumpStore.dumpTokens(neoStores.getPropertyKeyTokenStore(), ids);
    }

    private static void dumpLabels(NeoStores neoStores, long[] ids) throws Exception {
        DumpStore.dumpTokens(neoStores.getLabelTokenStore(), ids);
    }

    private static void dumpRelationshipTypes(NeoStores neoStores, long[] ids) throws Exception {
        DumpStore.dumpTokens(neoStores.getRelationshipTypeTokenStore(), ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends TokenRecord, T extends Token> void dumpTokens(final TokenStore<R, T> store, long[] ids) throws Exception {
        try {
            new DumpStore<R, TokenStore<R, T>>(System.out){

                @Override
                protected Object transform(R record) throws Exception {
                    if (((AbstractBaseRecord)record).inUse()) {
                        store.ensureHeavy(record);
                        return ((AbstractRecord)record).getId() + ": \"" + store.getStringFor(record) + "\": " + record;
                    }
                    return null;
                }
            }.dump(store, ids);
        }
        finally {
            store.close();
        }
    }

    private static void dumpRelationshipGroups(NeoStores neoStores, long[] ids) throws Exception {
        DumpStore.dump(ids, neoStores.getRelationshipGroupStore());
    }

    private static void dumpRelationshipStore(NeoStores neoStores, long[] ids) throws Exception {
        DumpStore.dump(ids, neoStores.getRelationshipStore());
    }

    private static void dumpPropertyStore(NeoStores neoStores, long[] ids) throws Exception {
        DumpStore.dump(ids, neoStores.getPropertyStore());
    }

    private static void dumpSchemaStore(NeoStores neoStores, long[] ids) throws Exception {
        try (SchemaStore store = neoStores.getSchemaStore();){
            final SchemaStorage storage = new SchemaStorage(store);
            new DumpStore<DynamicRecord, SchemaStore>(System.out){

                @Override
                protected Object transform(DynamicRecord record) throws Exception {
                    return record.inUse() && record.isStartRecord() ? storage.loadSingleSchemaRule(record.getId()) : null;
                }
            }.dump(store, ids);
        }
    }

    private static void dumpNodeStore(NeoStores neoStores, long[] ids) throws Exception {
        new DumpStore<NodeRecord, NodeStore>(System.out){

            @Override
            protected Object transform(NodeRecord record) throws Exception {
                return record.inUse() ? record : "";
            }
        }.dump(neoStores.getNodeStore(), ids);
    }

    protected DumpStore(PrintStream out) {
        this.out = out;
        this.printer = new HexPrinter(out).withBytesGroupingFormat(16, 4, "  ").withLineNumberDigits(8);
    }

    public final void dump(STORE store, long[] ids) throws Exception {
        int size = ((CommonAbstractStore)store).getRecordSize();
        this.out.println("store.getRecordSize() = " + size);
        this.out.println("<dump>");
        long used = 0L;
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        long highId = -1L;
        if (ids == null) {
            highId = ((CommonAbstractStore)store).getHighId();
            for (long id = 0L; id < highId; ++id) {
                boolean inUse = this.dumpRecord(store, size, id);
                if (!inUse) continue;
                ++used;
            }
        } else {
            for (long id : ids) {
                this.dumpRecord(store, size, id);
            }
        }
        this.out.println("</dump>");
        if (ids == null) {
            this.out.printf("used = %s / highId = %s (%.2f%%)%n", used, highId, (double)used * 100.0 / (double)highId);
        }
    }

    private boolean dumpRecord(STORE store, int size, long id) throws Exception {
        Object record = ((RecordStore)store).forceGetRecord(id);
        Object transform = this.transform(record);
        if (transform != null) {
            if (!"".equals(transform)) {
                this.out.println(transform);
            }
        } else {
            this.out.print(record);
            byte[] data = new byte[size];
            try (PageCursor pageCursor = ((CommonAbstractStore)store).storeFile.io(id / (long)((CommonAbstractStore)store).getRecordsPerPage(), 1);){
                if (pageCursor.next()) {
                    do {
                        pageCursor.setOffset((int)(id % (long)((CommonAbstractStore)store).getRecordsPerPage() * (long)size));
                        pageCursor.getBytes(data);
                    } while (pageCursor.shouldRetry());
                }
            }
            this.dumpHex(record, ByteBuffer.wrap(data), id, size);
        }
        return ((AbstractBaseRecord)record).inUse();
    }

    void dumpHex(RECORD record, ByteBuffer buffer, long id, int size) {
        this.printer.withLineNumberOffset(id * (long)size);
        if (((AbstractBaseRecord)record).inUse()) {
            this.printer.append(buffer);
        } else if (this.allZero(buffer)) {
            this.out.printf(": all zeros @ 0x%x - 0x%x", id * (long)size, (id + 1L) * (long)size);
        } else {
            this.printer.append(buffer);
        }
        this.out.printf("%n", new Object[0]);
    }

    private boolean allZero(ByteBuffer buffer) {
        for (int i = 0; i < buffer.limit(); ++i) {
            if (buffer.get(i) == 0) continue;
            return false;
        }
        return true;
    }

    protected Object transform(RECORD record) throws Exception {
        return ((AbstractBaseRecord)record).inUse() ? record : null;
    }
}

