/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.Map;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureSignature;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class ProcedureCache {
    private final Map<ProcedureSignature.ProcedureName, ProcedureDescriptor> procedures = new CopyOnWriteHashMap<ProcedureSignature.ProcedureName, ProcedureDescriptor>();

    public Iterator<ProcedureDescriptor> getAll() {
        return this.procedures.values().iterator();
    }

    public ProcedureDescriptor get(ProcedureSignature.ProcedureName name) {
        return this.procedures.get(name);
    }

    public synchronized void createProcedure(ProcedureDescriptor descriptor) {
        assert (!this.procedures.containsKey(descriptor.signature().name()));
        this.procedures.put(descriptor.signature().name(), descriptor);
    }

    public synchronized void dropProcedure(ProcedureDescriptor procedureDescriptor) {
        assert (this.procedures.containsKey(procedureDescriptor.signature().name()));
        this.procedures.remove(procedureDescriptor.signature().name());
    }
}

