/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.state.NeoStoreSupplier;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdGeneratorFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.io.IoTracer;

public class BatchingNeoStore
implements AutoCloseable,
NeoStoreSupplier {
    private final FileSystemAbstraction fileSystem;
    private final Monitors monitors;
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private final LogProvider logProvider;
    private final File storeDir;
    private final Config neo4jConfig;
    private final PageCache pageCache;
    private final NeoStore neoStore;
    private final LifeSupport life = new LifeSupport();
    private final LabelScanStore labelScanStore;
    private final IoTracer ioTracer;

    public BatchingNeoStore(FileSystemAbstraction fileSystem, File storeDir, Configuration config, LogService logService, Monitors monitors, AdditionalInitialIds initialIds) {
        this.fileSystem = fileSystem;
        this.monitors = monitors;
        this.logProvider = logService.getInternalLogProvider();
        this.storeDir = storeDir;
        this.neo4jConfig = new Config(MapUtil.stringMap(GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(config.denseNodeThreshold()), GraphDatabaseSettings.pagecache_memory.name(), String.valueOf(config.writeBufferSize())), GraphDatabaseSettings.class);
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        this.pageCache = BatchingNeoStore.createPageCache(fileSystem, this.neo4jConfig, this.logProvider, (PageCacheTracer)tracer);
        this.ioTracer = new IoTracer((PageCacheTracer)tracer){
            final /* synthetic */ PageCacheTracer val$tracer;
            {
                this.val$tracer = pageCacheTracer;
            }

            @Override
            public long countBytesWritten() {
                return this.val$tracer.countBytesWritten();
            }
        };
        this.neoStore = this.newNeoStore(this.pageCache);
        if (this.alreadyContainsData(this.neoStore)) {
            this.neoStore.close();
            throw new IllegalStateException(storeDir + " already contains data, cannot do import here");
        }
        try {
            this.neoStore.rebuildCountStoreIfNeeded();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.neoStore.setLastCommittedAndClosedTransactionId(initialIds.lastCommittedTransactionId(), initialIds.lastCommittedTransactionChecksum(), initialIds.lastCommittedTransactionLogVersion(), initialIds.lastCommittedTransactionLogByteOffset());
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStore.getPropertyKeyTokenStore(), initialIds.highPropertyKeyTokenId());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStore.getLabelTokenStore(), initialIds.highLabelTokenId());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStore.getRelationshipTypeTokenStore(), initialIds.highRelationshipTypeTokenId());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency(this.neo4jConfig);
        dependencies.satisfyDependency(fileSystem);
        dependencies.satisfyDependency(this);
        dependencies.satisfyDependency(logService);
        KernelContext kernelContext = new KernelContext(){

            @Override
            public FileSystemAbstraction fileSystem() {
                return BatchingNeoStore.this.fileSystem;
            }

            @Override
            public File storeDir() {
                return BatchingNeoStore.this.storeDir;
            }
        };
        KernelExtensions extensions = this.life.add(new KernelExtensions(kernelContext, Service.load(KernelExtensionFactory.class), dependencies, UnsatisfiedDependencyStrategies.ignore()));
        this.life.start();
        this.labelScanStore = this.life.add(extensions.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore());
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogProvider log, PageCacheTracer tracer) {
        return new ConfiguringPageCacheFactory(fileSystem, config, tracer, log.getLog(BatchingNeoStore.class)).getOrCreatePageCache();
    }

    private boolean alreadyContainsData(NeoStore neoStore) {
        return neoStore.getNodeStore().getHighId() > 0L || neoStore.getRelationshipStore().getHighId() > 0L;
    }

    public static void createStore(FileSystemAbstraction fileSystem, String storeDir) throws IOException {
        try (PageCache pageCache = BatchingNeoStore.createPageCache(fileSystem, new Config(), (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL);){
            StoreFactory storeFactory = new StoreFactory(fileSystem, new File(storeDir), pageCache, (LogProvider)NullLogProvider.getInstance(), new Monitors());
            storeFactory.createNeoStore().close();
        }
    }

    private NeoStore newNeoStore(PageCache pageCache) {
        BatchingIdGeneratorFactory idGeneratorFactory = new BatchingIdGeneratorFactory(this.fileSystem);
        StoreFactory storeFactory = new StoreFactory(this.storeDir, this.neo4jConfig, idGeneratorFactory, pageCache, this.fileSystem, this.logProvider, this.monitors);
        return storeFactory.newNeoStore(true);
    }

    public IoTracer getIoTracer() {
        return this.ioTracer;
    }

    public NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public BatchingTokenRepository.BatchingPropertyKeyTokenRepository getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository.BatchingLabelTokenRepository getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository.BatchingRelationshipTypeTokenRepository getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStore.getRelationshipGroupStore();
    }

    public CountsTracker getCountsStore() {
        return this.neoStore.getCounts();
    }

    @Override
    public void close() throws IOException {
        this.propertyKeyRepository.close();
        this.labelRepository.close();
        this.relationshipTypeRepository.close();
        this.life.shutdown();
        this.neoStore.close();
        this.pageCache.close();
    }

    public long getLastCommittedTransactionId() {
        return this.neoStore.getLastCommittedTransactionId();
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public NeoStore get() {
        return this.neoStore;
    }
}

