/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public interface JobScheduler
extends Lifecycle {
    public Executor executor(Group var1);

    public ThreadFactory threadFactory(Group var1);

    public JobHandle schedule(Group var1, Runnable var2);

    public JobHandle schedule(Group var1, Runnable var2, Map<String, String> var3);

    public JobHandle schedule(Group var1, Runnable var2, long var3, TimeUnit var5);

    public JobHandle scheduleRecurring(Group var1, Runnable var2, long var3, TimeUnit var5);

    public JobHandle scheduleRecurring(Group var1, Runnable var2, long var3, long var5, TimeUnit var7);

    public static interface JobHandle {
        public void cancel(boolean var1);
    }

    public static class Groups {
        public static final Group sessionWorker = new Group("Session", SchedulingStrategy.NEW_THREAD);
        public static final Group indexPopulation = new Group("IndexPopulation", SchedulingStrategy.POOLED);
        public static final Group masterTransactionPushing = new Group("TransactionPushing", SchedulingStrategy.POOLED);
        public static final Group serverTransactionTimeout = new Group("ServerTransactionTimeout", SchedulingStrategy.POOLED);
        public static final Group slaveLocksTimeout = new Group("SlaveLocksTimeout", SchedulingStrategy.POOLED);
        public static final Group pullUpdates = new Group("PullUpdates", SchedulingStrategy.POOLED);
        public static final Group indexSamplingController = new Group("IndexSamplingController", SchedulingStrategy.POOLED);
        public static final Group indexSampling = new Group("IndexSampling", SchedulingStrategy.POOLED);
        public static final Group internalLogRotation = new Group("InternalLogRotation", SchedulingStrategy.POOLED);
        public static final Group checkPoint = new Group("CheckPoint", SchedulingStrategy.POOLED);
        public static final Group boltNetworkIO = new Group("BoltNetworkIO", SchedulingStrategy.NEW_THREAD);
    }

    public static class Group {
        public static final String THREAD_ID = "thread-id";
        public static final Map<String, String> NO_METADATA = Collections.emptyMap();
        private final String name;
        private final SchedulingStrategy strategy;
        private final AtomicInteger threadCounter = new AtomicInteger(0);

        public Group(String name, SchedulingStrategy strategy) {
            this.name = name;
            this.strategy = strategy;
        }

        public String name() {
            return this.name;
        }

        public SchedulingStrategy strategy() {
            return this.strategy;
        }

        public String threadName(Map<String, String> metadata) {
            if (metadata.containsKey(THREAD_ID)) {
                return "neo4j." + this.name() + "-" + metadata.get(THREAD_ID);
            }
            return "neo4j." + this.name() + "-" + this.threadCounter.incrementAndGet();
        }
    }

    public static enum SchedulingStrategy {
        NEW_THREAD,
        POOLED;

    }
}

