/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import java.io.IOException;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogRotationImpl
implements LogRotation {
    private final LogRotation.Monitor monitor;
    private final LogFile logFile;
    private final KernelHealth kernelHealth;
    private final Log msgLog;

    public LogRotationImpl(LogRotation.Monitor monitor, LogFile logFile, KernelHealth kernelHealth, LogProvider logProvider) {
        this.monitor = monitor;
        this.logFile = logFile;
        this.kernelHealth = kernelHealth;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rotateLogIfNeeded(LogAppendEvent logAppendEvent) throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            if (this.logFile.rotationNeeded()) {
                try (LogRotateEvent rotateEvent = logAppendEvent.beginLogRotate();){
                    this.doRotate();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateLogFile() throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.doRotate();
        }
    }

    private void doRotate() throws IOException {
        long currentVersion = this.logFile.currentLogVersion();
        this.kernelHealth.assertHealthy(IOException.class);
        this.monitor.startedRotating(currentVersion);
        this.msgLog.info(LogRotation.PrintFormat.prefix(currentVersion) + " Preparing new log file...");
        this.logFile.rotate();
        this.monitor.finishedRotating(currentVersion);
    }
}

