/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;
    private final long transactionChecksum;
    private final long logVersion;
    private final long byteOffset;

    public ReadOnlyTransactionIdStore(PageCache pageCache, File storeDir) {
        long id = 0L;
        long checksum = 0L;
        long logVersion = 0L;
        long byteOffset = 0L;
        if (NeoStore.isStorePresent(pageCache, storeDir)) {
            File neoStore = new File(storeDir, "neostore");
            id = NeoStore.getRecord(pageCache, neoStore, NeoStore.Position.LAST_TRANSACTION_ID);
            checksum = NeoStore.getRecord(pageCache, neoStore, NeoStore.Position.LAST_TRANSACTION_CHECKSUM);
            logVersion = NeoStore.getRecord(pageCache, neoStore, NeoStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
            byteOffset = NeoStore.getRecord(pageCache, neoStore, NeoStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        }
        this.transactionId = id;
        this.transactionChecksum = checksum;
        this.logVersion = logVersion;
        this.byteOffset = byteOffset;
    }

    @Override
    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionCommitted(long transactionId, long checksum) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    @Override
    public long[] getLastCommittedTransaction() {
        return new long[]{this.transactionId, this.transactionChecksum};
    }

    @Override
    public long[] getUpgradeTransaction() {
        return this.getLastCommittedTransaction();
    }

    @Override
    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    @Override
    public long[] getLastClosedTransaction() {
        return new long[]{this.transactionId, this.logVersion, this.byteOffset};
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum, long logVersion, long logByteOffset) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionClosed(long transactionId, long logVersion, long logByteOffset) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public boolean closedTransactionIdIsOnParWithOpenedTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void flush() {
    }
}

