/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.StoreVersionTrailerUtil;

public class StoreVersionCheck {
    private final PageCache pageCache;

    public StoreVersionCheck(PageCache pageCache) {
        this.pageCache = pageCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result hasVersion(File storeFile, String expectedVersion) {
        String storeFilename = storeFile.getName();
        try (PagedFile file = this.pageCache.map(storeFile, this.pageCache.pageSize(), new OpenOption[0]);){
            if (file.getLastPageId() == -1L) {
                Result result = new Result(Result.Outcome.storeVersionNotFound, null, storeFilename);
                return result;
            }
            String actualVersion = StoreVersionTrailerUtil.readTrailer(file, expectedVersion);
            if (actualVersion == null) {
                Result result = new Result(Result.Outcome.storeVersionNotFound, null, storeFilename);
                return result;
            }
            if (!actualVersion.startsWith(this.typeDescriptor(expectedVersion))) {
                Result result = new Result(Result.Outcome.storeVersionNotFound, actualVersion, storeFilename);
                return result;
            }
            if (expectedVersion.equals(actualVersion)) return new Result(Result.Outcome.ok, null, storeFilename);
            Result result = new Result(Result.Outcome.unexpectedUpgradingStoreVersion, actualVersion, storeFilename);
            return result;
        }
        catch (IOException e) {
            return new Result(Result.Outcome.missingStoreFile, null, storeFilename);
        }
    }

    private String typeDescriptor(String expectedVersion) {
        int spaceIndex = expectedVersion.indexOf(32);
        if (spaceIndex == -1) {
            throw new IllegalArgumentException("Unexpected version " + expectedVersion);
        }
        return expectedVersion.substring(0, spaceIndex);
    }

    public static class Result {
        public final Outcome outcome;
        public final String actualVersion;
        public final String storeFilename;

        public Result(Outcome outcome, String actualVersion, String storeFilename) {
            this.outcome = outcome;
            this.actualVersion = actualVersion;
            this.storeFilename = storeFilename;
        }

        public static enum Outcome {
            ok(true),
            missingStoreFile(false),
            storeVersionNotFound(false),
            unexpectedUpgradingStoreVersion(false);

            private final boolean success;

            private Outcome(boolean success) {
                this.success = success;
            }

            public boolean isSuccessful() {
                return this.success;
            }
        }
    }
}

