/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.AbstractRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class DumpStore<RECORD extends AbstractBaseRecord, STORE extends CommonAbstractStore> {
    private final PrintStream out;
    private final HexPrinter printer;

    public static void main(String ... args) throws Exception {
        if (args == null || args.length == 0) {
            System.err.println("SYNTAX: [file[:id[,id]*]]+");
            return;
        }
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);){
            DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)fs);
            StoreFactory storeFactory = new StoreFactory(null, new Config(), idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, DumpStore.logProvider(), null);
            for (String arg : args) {
                DumpStore.dumpFile(storeFactory, arg);
            }
        }
    }

    private static void dumpFile(StoreFactory storeFactory, String arg) throws Exception {
        File file = new File(arg);
        long[] ids = null;
        if (!file.isFile() && !file.isDirectory() && file.getName().indexOf(58) != -1) {
            int idStart = arg.lastIndexOf(58);
            String[] idStrings = arg.substring(idStart + 1).split(",");
            ids = new long[idStrings.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = Long.parseLong(idStrings[i]);
            }
            file = new File(arg.substring(0, idStart));
            if (!file.isFile()) {
                throw new IllegalArgumentException("No such file: " + arg);
            }
        }
        switch (file.getName()) {
            case "neostore.nodestore.db": {
                DumpStore.dumpNodeStore(file, storeFactory, ids);
                break;
            }
            case "neostore.relationshipstore.db": {
                DumpStore.dumpRelationshipStore(file, storeFactory, ids);
                break;
            }
            case "neostore.propertystore.db": {
                DumpStore.dumpPropertyStore(file, storeFactory, ids);
                break;
            }
            case "neostore.schemastore.db": {
                DumpStore.dumpSchemaStore(file, storeFactory, ids);
                break;
            }
            case "neostore.propertystore.db.index": {
                DumpStore.dumpPropertyKeys(file, storeFactory, ids);
                break;
            }
            case "neostore.labeltokenstore.db": {
                DumpStore.dumpLabels(file, storeFactory, ids);
                break;
            }
            case "neostore.relationshiptypestore.db": {
                DumpStore.dumpRelationshipTypes(file, storeFactory, ids);
                break;
            }
            case "neostore.relationshipgroupstore.db": {
                DumpStore.dumpRelationshipGroups(file, storeFactory, ids);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown store file: " + arg);
            }
        }
    }

    private static LogProvider logProvider() {
        return Boolean.getBoolean("logger") ? FormattedLogProvider.toOutputStream((OutputStream)System.out) : NullLogProvider.getInstance();
    }

    private static void dumpPropertyKeys(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        DumpStore.dumpTokens(storeFactory.newPropertyKeyTokenStore(file), ids);
    }

    private static void dumpLabels(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        DumpStore.dumpTokens(storeFactory.newLabelTokenStore(file), ids);
    }

    private static void dumpRelationshipTypes(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        DumpStore.dumpTokens(storeFactory.newRelationshipTypeTokenStore(file), ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends TokenRecord, T extends Token> void dumpTokens(final TokenStore<R, T> store, long[] ids) throws Exception {
        try {
            new DumpStore<R, TokenStore<R, T>>(System.out){

                @Override
                protected Object transform(R record) throws Exception {
                    if (((AbstractBaseRecord)record).inUse()) {
                        store.ensureHeavy(record);
                        return ((AbstractRecord)record).getId() + ": \"" + store.getStringFor(record) + "\": " + record;
                    }
                    return null;
                }
            }.dump(store, ids);
        }
        finally {
            store.close();
        }
    }

    private static void dumpRelationshipGroups(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        try (RelationshipGroupStore store = storeFactory.newRelationshipGroupStore(file);){
            new DumpStore(System.out).dump(store, ids);
        }
    }

    private static void dumpRelationshipStore(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        try (RelationshipStore store = storeFactory.newRelationshipStore(file);){
            new DumpStore(System.out).dump(store, ids);
        }
    }

    private static void dumpPropertyStore(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        try (PropertyStore store = storeFactory.newPropertyStore(file);){
            new DumpStore(System.out).dump(store, ids);
        }
    }

    private static void dumpSchemaStore(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        try (SchemaStore store = storeFactory.newSchemaStore(file);){
            final SchemaStorage storage = new SchemaStorage(store);
            new DumpStore<DynamicRecord, SchemaStore>(System.out){

                @Override
                protected Object transform(DynamicRecord record) throws Exception {
                    return record.inUse() && record.isStartRecord() ? storage.loadSingleSchemaRule(record.getId()) : null;
                }
            }.dump(store, ids);
        }
    }

    private static void dumpNodeStore(File file, StoreFactory storeFactory, long[] ids) throws Exception {
        try (NodeStore store = storeFactory.newNodeStore(file);){
            new DumpStore<NodeRecord, NodeStore>(System.out){

                @Override
                protected Object transform(NodeRecord record) throws Exception {
                    return record.inUse() ? record : "";
                }
            }.dump(store, ids);
        }
    }

    protected DumpStore(PrintStream out) {
        this.out = out;
        this.printer = new HexPrinter(out).withBytesGroupingFormat(16, 4, "  ").withLineNumberDigits(8);
    }

    public final void dump(STORE store, long[] ids) throws Exception {
        ((CommonAbstractStore)store).makeStoreOk();
        int size = ((CommonAbstractStore)store).getRecordSize();
        this.out.println("store.getRecordSize() = " + size);
        this.out.println("<dump>");
        long used = 0L;
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        if (ids == null) {
            long high = ((CommonAbstractStore)store).getHighestPossibleIdInUse();
            for (long id = 0L; id <= high; ++id) {
                boolean inUse = this.dumpRecord(store, size, id);
                if (!inUse) continue;
                ++used;
            }
        } else {
            for (long id : ids) {
                this.dumpRecord(store, size, id);
            }
        }
        this.out.println("</dump>");
        if (ids == null) {
            this.out.printf("used = %s / highId = %s (%.2f%%)%n", used, ((CommonAbstractStore)store).getHighId(), (double)used * 100.0 / (double)((CommonAbstractStore)store).getHighId());
        }
    }

    private boolean dumpRecord(STORE store, int size, long id) throws Exception {
        Object record = ((RecordStore)store).forceGetRecord(id);
        Object transform = this.transform(record);
        if (transform != null) {
            if (!"".equals(transform)) {
                this.out.println(transform);
            }
        } else {
            this.out.print(record);
            byte[] data = new byte[size];
            try (PageCursor pageCursor = ((CommonAbstractStore)store).storeFile.io(id / (long)((CommonAbstractStore)store).recordsPerPage(), 1);){
                if (pageCursor.next()) {
                    do {
                        pageCursor.setOffset((int)(id % (long)((CommonAbstractStore)store).recordsPerPage() * (long)size));
                        pageCursor.getBytes(data);
                    } while (pageCursor.shouldRetry());
                }
            }
            this.dumpHex(record, ByteBuffer.wrap(data), id, size);
        }
        return ((AbstractBaseRecord)record).inUse();
    }

    void dumpHex(RECORD record, ByteBuffer buffer, long id, int size) {
        this.printer.withLineNumberOffset(id * (long)size);
        if (((AbstractBaseRecord)record).inUse()) {
            this.printer.append(buffer);
        } else if (this.allZero(buffer)) {
            this.out.printf(": all zeros @ 0x%x - 0x%x", id * (long)size, (id + 1L) * (long)size);
        } else {
            this.printer.append(buffer);
        }
        this.out.printf("%n", new Object[0]);
    }

    private boolean allZero(ByteBuffer buffer) {
        for (int i = 0; i < buffer.limit(); ++i) {
            if (buffer.get(i) == 0) continue;
            return false;
        }
        return true;
    }

    protected Object transform(RECORD record) throws Exception {
        return ((AbstractBaseRecord)record).inUse() ? record : null;
    }
}

