/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.StoreVersionTrailerUtil;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;

public abstract class CommonAbstractStore
implements IdSequence,
AutoCloseable {
    public static final String ALL_STORES_VERSION = "v0.A.6";
    public static final String UNKNOWN_VERSION = "Unknown";
    protected final Config configuration;
    protected final PageCache pageCache;
    protected final File storageFileName;
    protected final IdType idType;
    private final IdGeneratorFactory idGeneratorFactory;
    private final StoreVersionMismatchHandler versionMismatchHandler;
    protected final Log log;
    protected PagedFile storeFile;
    private IdGenerator idGenerator;
    private boolean storeOk = true;
    private Throwable causeOfStoreNotOk;
    private String readTypeDescriptorAndVersion;

    public CommonAbstractStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, StoreVersionMismatchHandler versionMismatchHandler) {
        this.storageFileName = fileName;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.idType = idType;
        this.log = logProvider.getLog(this.getClass());
        this.versionMismatchHandler = versionMismatchHandler;
        try {
            this.checkStorage();
            this.checkVersion();
            this.loadStorage();
        }
        catch (Exception e) {
            if (this.storeFile != null) {
                try {
                    this.storeFile.close();
                }
                catch (IOException failureToClose) {
                    e.addSuppressed(failureToClose);
                }
            }
            throw Exceptions.launderedException(e);
        }
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(typeDescriptor, ALL_STORES_VERSION);
    }

    public static String buildTypeDescriptorAndVersion(String typeDescriptor, String version) {
        return typeDescriptor + " " + version;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    public String getTypeAndVersionDescriptor() {
        return CommonAbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor());
    }

    public abstract String getTypeDescriptor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStorage() {
        try {
            PagedFile file = this.pageCache.map(this.storageFileName, this.pageCache.pageSize(), new OpenOption[0]);
            Throwable throwable = null;
            if (file != null) {
                if (throwable != null) {
                    try {
                        file.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    file.close();
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open file " + this.storageFileName, e);
        }
    }

    protected void checkVersion() {
        try {
            this.verifyCorrectTypeDescriptorAndVersion();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to check version " + this.getStorageFileName(), e);
        }
    }

    protected void loadStorage() {
        try {
            this.readAndVerifyBlockSize();
            this.verifyRecordAlignmentAndRemoveTrailer();
            try {
                int filePageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % this.getRecordSize();
                this.storeFile = this.pageCache.map(this.getStorageFileName(), filePageSize, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            this.loadIdGenerator();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load storage " + this.getStorageFileName(), e);
        }
    }

    private void verifyRecordAlignmentAndRemoveTrailer() throws IOException {
        String versionTrailer = CommonAbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor());
        int expectedVersionLength = UTF8.encode(versionTrailer).length;
        try (PagedFile pagedFile = this.pageCache.map(this.getStorageFileName(), this.pageCache.pageSize() - this.pageCache.pageSize() % this.getRecordSize(), new OpenOption[0]);){
            long trailerOffset = StoreVersionTrailerUtil.getTrailerOffset(pagedFile, versionTrailer.split(" ")[0]);
            if (trailerOffset != -1L && trailerOffset % (long)this.getRecordSize() == 0L) {
                StoreVersionTrailerUtil.writeTrailer(pagedFile, new byte[expectedVersionLength], trailerOffset);
            } else {
                this.setStoreNotOk(new IllegalStateException("Misaligned file size " + trailerOffset + " for " + this + ", expected version length:" + expectedVersionLength));
            }
        }
    }

    protected long pageIdForRecord(long id) {
        return id * (long)this.getRecordSize() / (long)this.storeFile.pageSize();
    }

    protected int offsetForId(long id) {
        return (int)(id * (long)this.getRecordSize() % (long)this.storeFile.pageSize());
    }

    protected int recordsPerPage() {
        return this.storeFile.pageSize() / this.getRecordSize();
    }

    protected abstract void readAndVerifyBlockSize() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIdGenerator() {
        try {
            if (this.storeOk) {
                this.openIdGenerator();
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk(e);
        }
        finally {
            if (!this.getStoreOk()) {
                this.log.debug(this.getStorageFileName() + " non clean shutdown detected");
            }
        }
    }

    protected void verifyCorrectTypeDescriptorAndVersion() throws IOException {
        String expectedTypeDescriptorAndVersion = this.getTypeAndVersionDescriptor();
        try (PagedFile pagedFile = this.pageCache.map(this.storageFileName, this.pageCache.pageSize(), new OpenOption[0]);){
            this.readTypeDescriptorAndVersion = StoreVersionTrailerUtil.readTrailer(pagedFile, expectedTypeDescriptorAndVersion);
        }
        if (this.readTypeDescriptorAndVersion == null) {
            this.setStoreNotOk(new IllegalStateException("No trailer present in store, expected " + expectedTypeDescriptorAndVersion));
            return;
        }
        if (!expectedTypeDescriptorAndVersion.equals(this.readTypeDescriptorAndVersion)) {
            if (this.readTypeDescriptorAndVersion.startsWith(this.getTypeDescriptor())) {
                this.versionMismatchHandler.mismatch(expectedTypeDescriptorAndVersion, this.readTypeDescriptorAndVersion);
            } else {
                this.setStoreNotOk(new IllegalStateException("Unexpected version " + this.readTypeDescriptorAndVersion + ", expected " + expectedTypeDescriptorAndVersion));
            }
        }
    }

    protected int getHeaderRecord() throws IOException {
        int headerRecord = 0;
        try (PagedFile pagedFile = this.pageCache.map(this.getStorageFileName(), this.pageCache.pageSize(), new OpenOption[0]);
             PageCursor pageCursor = pagedFile.io(0L, 1);){
            if (pageCursor.next()) {
                do {
                    headerRecord = pageCursor.getInt();
                } while (pageCursor.shouldRetry());
            }
        }
        if (headerRecord <= 0) {
            throw new InvalidRecordException("Illegal block size: " + headerRecord + " in " + this.getStorageFileName());
        }
        return headerRecord;
    }

    protected abstract boolean isInUse(byte var1);

    protected void rebuildIdGenerator() {
        boolean fastRebuild;
        long defraggedCount;
        block16: {
            int blockSize = this.getRecordSize();
            if (blockSize <= 0) {
                throw new InvalidRecordException("Illegal blockSize: " + blockSize);
            }
            this.log.debug("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
            this.closeIdGenerator();
            this.createIdGenerator(this.getIdFileName());
            this.openIdGenerator();
            defraggedCount = 0L;
            fastRebuild = this.doFastIdGeneratorRebuild();
            try {
                long foundHighId = this.findHighIdBackwards();
                this.setHighId(foundHighId);
                if (fastRebuild) break block16;
                try (PageCursor cursor = this.storeFile.io(0L, 10);){
                    defraggedCount = this.rebuildIdGeneratorSlow(cursor, this.recordsPerPage(), blockSize, foundHighId);
                }
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
            }
        }
        this.log.debug("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.log.debug(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount);
        if (!fastRebuild) {
            this.closeIdGenerator();
            this.openIdGenerator();
        }
    }

    private long rebuildIdGeneratorSlow(PageCursor cursor, int recordsPerPage, int blockSize, long foundHighId) throws IOException {
        long defragCount = 0L;
        long[] freedBatch = new long[recordsPerPage];
        int startingId = this.getNumberOfReservedLowIds();
        boolean done = false;
        while (!done && cursor.next()) {
            int i;
            int defragged;
            long idPageOffset = cursor.getCurrentPageId() * (long)recordsPerPage;
            block1: do {
                defragged = 0;
                done = false;
                for (i = startingId; i < recordsPerPage; ++i) {
                    int offset = i * blockSize;
                    cursor.setOffset(offset);
                    long recordId = idPageOffset + (long)i;
                    if (recordId >= foundHighId) {
                        done = true;
                        continue block1;
                    }
                    if (!this.isRecordInUse(cursor)) {
                        freedBatch[defragged++] = recordId;
                        continue;
                    }
                    if (!this.isRecordReserved(cursor)) continue;
                    cursor.setOffset(offset);
                    cursor.putByte(Record.NOT_IN_USE.byteValue());
                    cursor.putInt(0);
                    freedBatch[defragged++] = recordId;
                }
            } while (cursor.shouldRetry());
            for (i = 0; i < defragged; ++i) {
                this.freeId(freedBatch[i]);
            }
            defragCount += (long)defragged;
            startingId = 0;
        }
        return defragCount;
    }

    protected boolean doFastIdGeneratorRebuild() {
        return this.configuration.get(Configuration.rebuild_idgenerators_fast);
    }

    protected void closeStorage() {
    }

    protected void setStoreNotOk(Throwable cause) {
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
        this.idGenerator = null;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    protected void checkStoreOk() {
        if (!this.storeOk) {
            throw Exceptions.launderedException(this.causeOfStoreNotOk);
        }
    }

    @Override
    public long nextId() {
        return this.idGenerator.nextId();
    }

    public void freeId(long id) {
        if (this.idGenerator != null) {
            this.idGenerator.freeId(id);
        }
    }

    public long getHighId() {
        return this.idGenerator != null ? this.idGenerator.getHighId() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighId(long highId) {
        if (this.idGenerator != null) {
            IdGenerator idGenerator = this.idGenerator;
            synchronized (idGenerator) {
                if (highId > this.idGenerator.getHighId()) {
                    this.idGenerator.setHighId(highId);
                }
            }
        }
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            this.rebuildIdGenerator();
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    private File getIdFileName() {
        return new File(this.getStorageFileName().getPath() + ".id");
    }

    protected void openIdGenerator() {
        this.idGenerator = this.openIdGenerator(this.getIdFileName(), this.idType.getGrabSize());
    }

    protected IdGenerator openIdGenerator(File fileName, int grabSize) {
        try {
            return this.idGeneratorFactory.open(fileName, grabSize, this.getIdType(), this.findHighIdBackwards());
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to find high id by scanning backwards " + this.getStorageFileName(), e);
        }
    }

    protected long findHighIdBackwards() throws IOException {
        try (PageCursor cursor = this.storeFile.io(0L, 1);){
            long nextPageId = this.storeFile.getLastPageId();
            int recordsPerPage = this.recordsPerPage();
            int recordSize = this.getRecordSize();
            while (nextPageId >= 0L && cursor.next(nextPageId)) {
                --nextPageId;
                do {
                    int currentRecord = recordsPerPage;
                    while (currentRecord-- > 0) {
                        cursor.setOffset(currentRecord * recordSize);
                        long recordId = cursor.getCurrentPageId() * (long)recordsPerPage + (long)currentRecord;
                        if (!this.isRecordInUse(cursor)) continue;
                        long l = recordId + 1L;
                        return l;
                    }
                } while (cursor.shouldRetry());
            }
            long l = this.getNumberOfReservedLowIds();
            return l;
        }
    }

    public abstract int getRecordSize();

    protected boolean isRecordInUse(PageCursor cursor) {
        return this.isInUse(cursor.getByte());
    }

    protected boolean isRecordReserved(PageCursor cursor) {
        return false;
    }

    protected void createIdGenerator(File fileName) {
        this.idGeneratorFactory.create(fileName, 0L, false);
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    public void flush() {
        try {
            this.storeFile.flushAndForce();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", e);
        }
    }

    @Override
    public void close() {
        this.closeStorage();
        if (this.idGenerator == null || !this.storeOk) {
            try {
                this.storeFile.close();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Failed to close store file: " + this.getStorageFileName(), e);
            }
            return;
        }
        try {
            long trailerOffset = this.idGenerator.getHighId() * (long)this.getRecordSize();
            this.idGenerator.close();
            this.log.debug("Closing " + this.storageFileName + ", writing trailer at " + trailerOffset);
            StoreVersionTrailerUtil.writeTrailer(this.storeFile, UTF8.encode(this.versionMismatchHandler.trailerToWrite(this.getTypeAndVersionDescriptor(), this.readTypeDescriptorAndVersion)), trailerOffset);
            this.storeFile.close();
        }
        catch (IOException | IllegalStateException e) {
            throw new UnderlyingStorageException("Failed to close store file: " + this.getStorageFileName(), e);
        }
    }

    public long getHighestPossibleIdInUse() {
        if (this.idGenerator != null) {
            return this.idGenerator.getHighestPossibleIdInUse();
        }
        return this.calculateHighestIdInUseByLookingAtFileSize();
    }

    public void setHighestPossibleIdInUse(long highId) {
        this.setHighId(highId + 1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long calculateHighestIdInUseByLookingAtFileSize() {
        int recordAlignedPageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % this.getRecordSize();
        try (PagedFile pagedFile = this.pageCache.map(this.getStorageFileName(), recordAlignedPageSize, new OpenOption[0]);){
            long id = (long)this.recordsPerPage() * (pagedFile.getLastPageId() + 1L);
            if (id == 0L) {
                long l = -1L;
                return l;
            }
            long l = id;
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getNumberOfIdsInUse() {
        return this.idGenerator.getNumberOfIdsInUse();
    }

    public int getNumberOfReservedLowIds() {
        return 0;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void logVersions(Logger logger) {
        logger.log("  " + this.getTypeAndVersionDescriptor());
    }

    public void logIdUsage(Logger logger) {
        logger.log(String.format("  %s: used=%s high=%s", this.getTypeDescriptor(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse()));
    }

    public void visitStore(Visitor<CommonAbstractStore, RuntimeException> visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static abstract class Configuration {
        public static final Setting<Boolean> rebuild_idgenerators_fast = GraphDatabaseSettings.rebuild_idgenerators_fast;
    }
}

