/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Consumer;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.api.store.StoreAbstractNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class StoreIteratorNodeCursor
extends StoreAbstractNodeCursor {
    private PrimitiveLongIterator iterator;
    private Consumer<StoreIteratorNodeCursor> instanceCache;

    public StoreIteratorNodeCursor(NodeRecord nodeRecord, NeoStore neoStore, StoreStatement storeStatement, Consumer<StoreIteratorNodeCursor> instanceCache) {
        super(nodeRecord, neoStore, storeStatement);
        this.instanceCache = instanceCache;
    }

    public StoreIteratorNodeCursor init(PrimitiveLongIterator iterator) {
        this.iterator = iterator;
        return this;
    }

    public boolean next() {
        while (this.iterator != null && this.iterator.hasNext()) {
            NodeRecord record = this.neoStore.getNodeStore().loadRecord(this.iterator.next(), this.nodeRecord);
            if (record == null || !record.inUse()) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.iterator instanceof Resource) {
            ((Resource)this.iterator).close();
        }
        this.iterator = null;
        this.instanceCache.accept((Object)this);
    }
}

