/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.extension.KernelExtensionUtil;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.state.NeoStoreSupplier;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LabelScanStoreProvider
extends LifecycleAdapter
implements Comparable<LabelScanStoreProvider> {
    public static DependencyResolver.SelectionStrategy HIGHEST_PRIORITIZED = new DependencyResolver.SelectionStrategy(){

        @Override
        public <T> T select(Class<T> type, Iterable<T> candidates) throws IllegalArgumentException {
            List all = IteratorUtil.addToCollection(candidates, new ArrayList());
            if (all.isEmpty()) {
                throw new IllegalArgumentException("No label scan store provider " + LabelScanStoreProvider.class.getName() + " found. " + KernelExtensionUtil.servicesClassPathEntryInformation());
            }
            Collections.sort(all);
            return (T)all.get(all.size() - 1);
        }
    };
    private final LabelScanStore labelScanStore;
    private final int priority;

    public LabelScanStoreProvider(LabelScanStore labelScanStore, int priority) {
        this.labelScanStore = labelScanStore;
        this.priority = priority;
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    @Override
    public int compareTo(LabelScanStoreProvider o) {
        return this.priority - o.priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.labelScanStore + ", prio:" + this.priority + "]";
    }

    public static FullStoreChangeStream fullStoreLabelUpdateStream(final NeoStoreSupplier neoStoreSupplier) {
        return new FullStoreChangeStream(){

            @Override
            public Iterator<NodeLabelUpdate> iterator() {
                return new PrefetchingIterator<NodeLabelUpdate>(){
                    private final NodeStore nodeStore;
                    private final long highId;
                    private long current;
                    {
                        this.nodeStore = ((NeoStore)neoStoreSupplier.get()).getNodeStore();
                        this.highId = this.nodeStore.getHighestPossibleIdInUse();
                    }

                    @Override
                    protected NodeLabelUpdate fetchNextOrNull() {
                        while (this.current <= this.highId) {
                            long[] labels;
                            NodeRecord node;
                            if (!(node = this.nodeStore.forceGetRecord(this.current++)).inUse() || (labels = NodeLabelsField.parseLabelsField(node).get(this.nodeStore)).length <= 0) continue;
                            return NodeLabelUpdate.labelChanges(node.getId(), PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels);
                        }
                        return null;
                    }
                };
            }

            @Override
            public long highestNodeId() {
                return ((NeoStore)neoStoreSupplier.get()).getNodeStore().getHighestPossibleIdInUse();
            }
        };
    }

    public static interface FullStoreChangeStream
    extends Iterable<NodeLabelUpdate> {
        public long highestNodeId();
    }
}

