/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;

public class PopulatingIndexProxy
implements IndexProxy {
    private final JobScheduler scheduler;
    private final IndexDescriptor descriptor;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final IndexPopulationJob job;
    private final IndexConfiguration configuration;

    public PopulatingIndexProxy(JobScheduler scheduler, IndexDescriptor descriptor, IndexConfiguration configuration, FailedIndexProxyFactory failureDelegateFactory, IndexPopulator writer, FlippableIndexProxy flipper, IndexStoreView storeView, UpdateableSchemaState updateableSchemaState, LogProvider logProvider, String indexUserDescription, SchemaIndexProvider.Descriptor providerDescriptor, IndexingService.Monitor monitor) {
        this.scheduler = scheduler;
        this.descriptor = descriptor;
        this.configuration = configuration;
        this.providerDescriptor = providerDescriptor;
        this.job = new IndexPopulationJob(descriptor, configuration, providerDescriptor, indexUserDescription, failureDelegateFactory, writer, flipper, storeView, updateableSchemaState, logProvider, monitor);
    }

    @Override
    public void start() {
        this.scheduler.schedule(JobScheduler.Groups.indexPopulation, this.job);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: {
                return new PopulatingIndexUpdater(){

                    @Override
                    public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                        PopulatingIndexProxy.this.job.update(update);
                    }
                };
            }
            case RECOVERY: {
                return new PopulatingIndexUpdater(){

                    @Override
                    public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                        throw new UnsupportedOperationException("Recovered updates shouldn't reach this place");
                    }
                };
            }
        }
        return new PopulatingIndexUpdater(){

            @Override
            public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                throw new ThisShouldNotHappenError("Stefan", "Unsupported IndexUpdateMode");
            }
        };
    }

    @Override
    public Future<Void> drop() {
        return this.job.cancel();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public void force() {
    }

    @Override
    public Future<Void> close() {
        return this.job.cancel();
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException("Index is still populating: " + this.job);
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        this.job.awaitCompletion();
        return true;
    }

    @Override
    public void activate() throws IndexActivationFailedKernelException {
        throw new IllegalStateException("Cannot activate index while it is still populating: " + this.job);
    }

    @Override
    public void validate() {
        throw new IllegalStateException("Cannot validate index while it is still populating: " + this.job);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return IteratorUtil.emptyIterator();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is POPULATING");
    }

    @Override
    public IndexConfiguration config() {
        return this.configuration;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + this.job + "]";
    }

    private abstract class PopulatingIndexUpdater
    implements IndexUpdater {
        private PopulatingIndexUpdater() {
        }

        @Override
        public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException, IndexCapacityExceededException {
            return Reservation.EMPTY;
        }

        @Override
        public void close() throws IOException, IndexEntryConflictException {
        }

        @Override
        public void remove(PrimitiveLongSet nodeIds) {
            throw new UnsupportedOperationException("Should not remove() from populating index.");
        }
    }
}

