/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import org.neo4j.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStage;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountingStoreUpdateMonitor;
import org.neo4j.unsafe.impl.batchimport.IdMapperPreparationStage;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.NodeStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipStage;
import org.neo4j.unsafe.impl.batchimport.WriterFactories;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final IoMonitor writeMonitor;
    private final LogService logService;
    private final Log log;
    private final ExecutionMonitor executionMonitor;
    private final Monitors monitors;
    private final BatchingPageCache.WriterFactory writerFactory;
    private final AdditionalInitialIds additionalInitialIds;

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, Configuration config, LogService logService, ExecutionMonitor executionMonitor, Function<Configuration, BatchingPageCache.WriterFactory> writerFactory, AdditionalInitialIds additionalInitialIds) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logService = logService;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
        this.monitors = new Monitors();
        this.writeMonitor = new IoMonitor();
        this.writerFactory = (BatchingPageCache.WriterFactory)writerFactory.apply((Object)config);
    }

    public ParallelBatchImporter(File storeDir, Configuration config, LogService logService, ExecutionMonitor executionMonitor) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), config, logService, ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config), WriterFactories.parallel(), AdditionalInitialIds.EMPTY);
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.log.info("Import starting");
        NodeRelationshipCache nodeRelationshipCache = null;
        NodeLabelsCache nodeLabelsCache = null;
        long startTime = System.currentTimeMillis();
        boolean hasBadEntries = false;
        File badFile = new File(this.storeDir, "bad.log");
        CountingStoreUpdateMonitor storeUpdateMonitor = new CountingStoreUpdateMonitor();
        try (BatchingNeoStore neoStore = new BatchingNeoStore(this.fileSystem, this.storeDir, this.config, this.writeMonitor, this.logService, this.monitors, this.writerFactory, this.additionalInitialIds);
             BufferedOutputStream badOutput = new BufferedOutputStream(this.fileSystem.openAsOutputStream(badFile, false));
             Collector badCollector = input.badCollector(badOutput);
             CountsAccessor.Updater countsUpdater = neoStore.getCountsStore().reset(neoStore.getLastCommittedTransactionId());
             InputCache inputCache = new InputCache(this.fileSystem, this.storeDir);){
            IdMapper idMapper = input.idMapper();
            IdGenerator idGenerator = input.idGenerator();
            nodeRelationshipCache = new NodeRelationshipCache(NumberArrayFactory.AUTO, this.config.denseNodeThreshold());
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(nodeRelationshipCache, idMapper);
            InputIterable<InputNode> nodes = input.nodes();
            InputIterable<InputRelationship> relationships = input.relationships();
            NodeStage nodeStage = new NodeStage(this.config, this.writeMonitor, this.writerFactory, nodes, idMapper, idGenerator, neoStore, inputCache, neoStore.getLabelScanStore(), storeUpdateMonitor, memoryUsageStats);
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(this.config, relationships, nodeRelationshipCache, idMapper, badCollector, inputCache);
            if (idMapper.needsPreparation()) {
                this.executeStages(nodeStage);
                this.executeStages(new IdMapperPreparationStage(this.config, idMapper, nodes, inputCache, badCollector, memoryUsageStats));
                this.executeStages(calculateDenseNodesStage);
            } else {
                this.executeStages(nodeStage, calculateDenseNodesStage);
            }
            nodeRelationshipCache.fixateNodes();
            RelationshipStage relationshipStage = new RelationshipStage(this.config, this.writeMonitor, this.writerFactory, relationships.supportsMultiplePasses() ? relationships : inputCache.relationships(), idMapper, neoStore, nodeRelationshipCache, input.specificRelationshipIds(), storeUpdateMonitor);
            this.executeStages(relationshipStage);
            nodeRelationshipCache.fixateGroups();
            neoStore.flush();
            this.writerFactory.awaitEverythingWritten();
            this.executeStages(new NodeFirstRelationshipStage(this.config, neoStore.getNodeStore(), neoStore.getRelationshipGroupStore(), nodeRelationshipCache, badCollector, neoStore.getLabelScanStore()));
            nodeRelationshipCache.clearRelationships();
            this.executeStages(new RelationshipLinkbackStage(this.config, neoStore.getRelationshipStore(), nodeRelationshipCache));
            nodeRelationshipCache.close();
            nodeRelationshipCache = null;
            nodeLabelsCache = new NodeLabelsCache(NumberArrayFactory.AUTO, neoStore.getLabelRepository().getHighId());
            memoryUsageStats = new MemoryUsageStatsProvider(nodeLabelsCache);
            this.executeStages(new NodeCountsStage(this.config, nodeLabelsCache, neoStore.getNodeStore(), neoStore.getLabelRepository().getHighId(), countsUpdater, memoryUsageStats));
            this.executeStages(new RelationshipCountsStage(this.config, nodeLabelsCache, neoStore.getRelationshipStore(), neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater, NumberArrayFactory.AUTO));
            this.writerFactory.awaitEverythingWritten();
            long totalTimeMillis = System.currentTimeMillis() - startTime;
            this.executionMonitor.done(totalTimeMillis, storeUpdateMonitor.toString());
            this.log.info("Import completed, took " + Format.duration(totalTimeMillis) + ". " + storeUpdateMonitor);
            boolean bl = hasBadEntries = badCollector.badEntries() > 0;
            if (hasBadEntries) {
                this.log.warn("There were " + badCollector.badEntries() + " bad entries which were skipped " + "and logged into " + badFile.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            this.log.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
        finally {
            this.writerFactory.shutdown();
            if (nodeRelationshipCache != null) {
                nodeRelationshipCache.close();
            }
            if (nodeLabelsCache != null) {
                nodeLabelsCache.close();
            }
            if (!hasBadEntries) {
                this.fileSystem.deleteFile(badFile);
            }
        }
    }

    private void executeStages(Stage ... stages) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stages);
    }
}

