/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveIntIterator;
import org.neo4j.kernel.impl.util.DiffApplyingRelationshipIterator;
import org.neo4j.kernel.impl.util.diffsets.ReadableRelationshipDiffSets;
import org.neo4j.kernel.impl.util.diffsets.SuperDiffSets;

public class RelationshipDiffSets<T>
extends SuperDiffSets<T, RelationshipIterator>
implements ReadableRelationshipDiffSets<T> {
    private RelationshipVisitor.Home txStateRelationshipHome;
    private static final RelationshipDiffSets EMPTY = new RelationshipDiffSets(null, Collections.emptySet(), Collections.emptySet()){

        @Override
        public Iterator apply(Iterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augment(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augmentWithRemovals(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augmentWithAdditions(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public RelationshipDiffSets filterAdded(Predicate addedFilter) {
            return this;
        }

        @Override
        public RelationshipDiffSets filter(Predicate filter) {
            return this;
        }
    };

    public static <T> RelationshipDiffSets<T> emptyDiffSets() {
        return EMPTY;
    }

    public RelationshipDiffSets(RelationshipVisitor.Home txStateRelationshipHome) {
        this(txStateRelationshipHome, null, null);
    }

    public RelationshipDiffSets(RelationshipVisitor.Home txStateRelationshipHome, Set<T> addedElements, Set<T> removedElements) {
        super(addedElements, removedElements);
        this.txStateRelationshipHome = txStateRelationshipHome;
    }

    @Override
    public RelationshipIterator augment(RelationshipIterator source) {
        return new DiffApplyingRelationshipIterator(source, this.added(false), this.removed(false), this.txStateRelationshipHome);
    }

    @Override
    public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
        return new DiffApplyingPrimitiveIntIterator(source, this.added(false), this.removed(false));
    }

    @Override
    public RelationshipIterator augmentWithRemovals(RelationshipIterator source) {
        return new DiffApplyingRelationshipIterator(source, Collections.emptySet(), this.removed(false), this.txStateRelationshipHome);
    }

    @Override
    public RelationshipIterator augmentWithAdditions(RelationshipIterator source) {
        return new DiffApplyingRelationshipIterator(source, this.added(false), Collections.emptySet(), this.txStateRelationshipHome);
    }

    @Override
    public RelationshipDiffSets<T> filterAdded(Predicate<T> addedFilter) {
        return new RelationshipDiffSets<T>(this.txStateRelationshipHome, IteratorUtil.asSet(Iterables.filter(addedFilter, this.added(false))), IteratorUtil.asSet(this.removed(false)));
    }

    @Override
    public RelationshipDiffSets<T> filter(Predicate<T> filter) {
        return new RelationshipDiffSets<T>(this.txStateRelationshipHome, IteratorUtil.asSet(Iterables.filter(filter, this.added(false))), IteratorUtil.asSet(Iterables.filter(filter, this.removed(false))));
    }
}

