/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogPruning
implements LogRotation.Monitor {
    private final Lock pruneLock = new ReentrantLock();
    private final LogPruneStrategy pruneStrategy;
    private final Log msgLog;

    public LogPruning(LogPruneStrategy pruneStrategy, LogProvider logProvider) {
        this.pruneStrategy = pruneStrategy;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    @Override
    public void startedRotating(long currentVersion) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishedRotating(long currentVersion) {
        if (this.pruneLock.tryLock()) {
            Thread thread = Thread.currentThread();
            String threadStr = "[" + thread.getId() + ":" + thread.getName() + "]";
            this.msgLog.info(LogRotation.PrintFormat.prefix(currentVersion) + threadStr + " Starting log pruning.");
            try {
                this.pruneStrategy.prune();
            }
            finally {
                this.pruneLock.unlock();
            }
            this.msgLog.info(LogRotation.PrintFormat.prefix(currentVersion) + threadStr + " Log pruning complete.");
        }
    }
}

