/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.DefaultLogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

public class LogEntryReaderFactory {
    private final LogEntryParserFactory logEntryParserFactory;
    private final CommandReaderFactory commandReaderFactory;

    public LogEntryReaderFactory() {
        this(new DefaultLogEntryParserFactory(), new CommandReaderFactory.Default());
    }

    public LogEntryReaderFactory(LogEntryParserFactory logEntryParserFactory, CommandReaderFactory commandReaderFactory) {
        this.logEntryParserFactory = logEntryParserFactory;
        this.commandReaderFactory = commandReaderFactory;
    }

    public <T extends ReadableVersionableLogChannel> LogEntryReader<T> versionable() {
        final VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(this.logEntryParserFactory, this.commandReaderFactory);
        return new LogEntryReader<T>(){

            @Override
            public LogEntry readLogEntry(T channel) throws IOException {
                return reader.readLogEntry((ReadableLogChannel)channel, channel.getLogFormatVersion());
            }
        };
    }

    public <T extends ReadableLogChannel> LogEntryReader<T> create() {
        final VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(this.logEntryParserFactory, this.commandReaderFactory);
        return new LogEntryReader<T>(){

            @Override
            public LogEntry readLogEntry(T channel) throws IOException {
                return reader.readLogEntry((ReadableLogChannel)channel, (byte)6);
            }
        };
    }
}

