/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;

public class TransactionLogWriter {
    private final LogEntryWriter writer;

    public TransactionLogWriter(LogEntryWriter writer) {
        this.writer = writer;
    }

    public void append(TransactionRepresentation transaction, long transactionId) throws IOException {
        this.writer.writeStartEntry(transaction.getMasterId(), transaction.getAuthorId(), transaction.getTimeStarted(), transaction.getLatestCommittedTxWhenStarted(), transaction.additionalHeader());
        this.writer.serialize(transaction);
        this.writer.writeCommitEntry(transactionId, transaction.getTimeCommitted());
    }

    public void checkPoint(long transactionId, LogPosition logPosition) throws IOException {
        this.writer.writeCheckPointEntry(transactionId, logPosition);
    }
}

