/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class NeoStoreTransactionApplier
extends NeoCommandHandler.Adapter {
    private final NeoStore neoStore;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;
    private final LockGroup lockGroup;
    private final long transactionId;

    public NeoStoreTransactionApplier(NeoStore store, CacheAccessBackDoor cacheAccess, LockService lockService, LockGroup lockGroup, long transactionId) {
        this.neoStore = store;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
        this.transactionId = transactionId;
        this.lockGroup = lockGroup;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.lockGroup.add(this.lockService.acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK));
        NodeStore nodeStore = this.neoStore.getNodeStore();
        nodeStore.updateRecord(command.getAfter());
        nodeStore.updateDynamicLabelRecords(command.getAfter().getDynamicLabelRecords());
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        RelationshipRecord record = command.getRecord();
        this.neoStore.getRelationshipStore().updateRecord(record);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        long nodeId = command.getNodeId();
        if (nodeId != -1L) {
            this.lockGroup.add(this.lockService.acquireNodeLock(nodeId, LockService.LockType.WRITE_LOCK));
        }
        this.neoStore.getPropertyStore().updateRecord(command.getAfter());
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        this.neoStore.getRelationshipGroupStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        this.neoStore.getRelationshipTypeTokenStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        this.neoStore.getLabelTokenStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        this.neoStore.getPropertyKeyTokenStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        SchemaStore schemaStore = this.neoStore.getSchemaStore();
        for (DynamicRecord record : command.getRecordsAfter()) {
            schemaStore.updateRecord(record);
        }
        if (command.getSchemaRule() instanceof UniquenessConstraintRule) {
            switch (command.getMode()) {
                case UPDATE: 
                case CREATE: {
                    this.neoStore.setLatestConstraintIntroducingTx(this.transactionId);
                    break;
                }
                case DELETE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        switch (command.getMode()) {
            case DELETE: {
                this.cacheAccess.removeSchemaRuleFromCache(command.getKey());
                break;
            }
            default: {
                this.cacheAccess.addSchemaRule(command.getSchemaRule());
            }
        }
        return false;
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        this.neoStore.setGraphNextProp(command.getRecord().getNextProp());
        return false;
    }
}

