/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class NodeRecord
extends PrimitiveRecord {
    private long nextRel = Record.NO_NEXT_RELATIONSHIP.intValue();
    private long labels = Record.NO_LABELS_FIELD.intValue();
    private Collection<DynamicRecord> dynamicLabelRecords = Collections.emptyList();
    private boolean isLight = true;
    private boolean dense;
    private static final Predicate<DynamicRecord> RECORDS_IN_USE = new Predicate<DynamicRecord>(){

        public boolean test(DynamicRecord item) {
            return item.inUse();
        }
    };

    public NodeRecord(long id) {
        super(id, Record.NO_NEXT_PROPERTY.intValue());
    }

    public NodeRecord(long id, boolean dense, long nextRel, long nextProp) {
        this(id, false, dense, nextRel, nextProp, 0L);
    }

    public NodeRecord(long id, boolean inUse, boolean dense, long nextRel, long nextProp, long labels) {
        super(id, nextProp);
        this.nextRel = nextRel;
        this.dense = dense;
        this.labels = labels;
        this.setInUse(inUse);
    }

    public NodeRecord(long id, boolean dense, long nextRel, long nextProp, boolean inUse) {
        this(id, dense, nextRel, nextProp);
        this.setInUse(inUse);
    }

    public long getNextRel() {
        return this.nextRel;
    }

    public void setNextRel(long nextRel) {
        this.nextRel = nextRel;
    }

    public void setLabelField(long labels, Collection<DynamicRecord> dynamicRecords) {
        this.labels = labels;
        this.dynamicLabelRecords = dynamicRecords;
        this.isLight = dynamicRecords.isEmpty();
    }

    public long getLabelField() {
        return this.labels;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public Collection<DynamicRecord> getDynamicLabelRecords() {
        return this.dynamicLabelRecords;
    }

    public Iterable<DynamicRecord> getUsedDynamicLabelRecords() {
        return Iterables.filter(RECORDS_IN_USE, this.dynamicLabelRecords);
    }

    public boolean isDense() {
        return this.dense;
    }

    public void setDense(boolean dense) {
        this.dense = dense;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Node[").append(this.getId()).append(",used=").append(this.inUse()).append("," + (this.dense ? "group" : "rel") + "=").append(this.nextRel).append(",prop=").append(this.getNextProp()).append(",labels=").append(NodeLabelsField.parseLabelsField(this)).append(",").append(this.isLight ? "light" : "heavy");
        if (!this.isLight && !this.dynamicLabelRecords.isEmpty()) {
            builder.append(",dynlabels=").append(this.dynamicLabelRecords);
        }
        return builder.append("]").toString();
    }

    @Override
    public void setIdTo(PropertyRecord property) {
        property.setNodeId(this.getId());
    }

    @Override
    public NodeRecord clone() {
        NodeRecord clone = new NodeRecord(this.getId(), this.dense, this.nextRel, this.getNextProp());
        clone.labels = this.labels;
        clone.isLight = this.isLight;
        clone.setInUse(this.inUse());
        if (this.dynamicLabelRecords.size() > 0) {
            ArrayList<DynamicRecord> clonedLabelRecords = new ArrayList<DynamicRecord>(this.dynamicLabelRecords.size());
            for (DynamicRecord labelRecord : this.dynamicLabelRecords) {
                clonedLabelRecords.add(labelRecord.clone());
            }
            clone.dynamicLabelRecords = clonedLabelRecords;
        }
        return clone;
    }

    public void copyFrom(NodeRecord from) {
        this.nextRel = from.nextRel;
        this.labels = from.labels;
        this.isLight = from.isLight;
        this.dense = from.dense;
        this.setNextProp(from.getNextProp());
    }
}

