/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;

public class SchemaStorage
implements SchemaRuleAccess {
    private final RecordStore<DynamicRecord> schemaStore;

    public SchemaStorage(RecordStore<DynamicRecord> schemaStore) {
        this.schemaStore = schemaStore;
    }

    public IndexRule indexRule(int labelId, int propertyKeyId) {
        return this.indexRule(labelId, propertyKeyId, IndexRuleKind.ALL);
    }

    public IndexRule indexRule(int labelId, final int propertyKeyId, IndexRuleKind kind) {
        Iterator<IndexRule> rules = this.schemaRules(IndexRule.class, labelId, new Predicate<IndexRule>(){

            public boolean test(IndexRule item) {
                return item.getPropertyKey() == propertyKeyId;
            }
        });
        IndexRule foundRule = null;
        while (rules.hasNext()) {
            IndexRule candidate = rules.next();
            if (!kind.isOfKind(candidate)) continue;
            if (foundRule != null) {
                throw new ThisShouldNotHappenError("Jake", String.format("Found more than one matching index rule, %s and %s", foundRule, candidate));
            }
            foundRule = candidate;
        }
        return foundRule;
    }

    public Iterator<IndexRule> allIndexRules() {
        return this.schemaRules(IndexRule.class);
    }

    public <T extends SchemaRule> Iterator<T> schemaRules(Class<T> type, int labelId, Predicate<T> predicate) {
        return this.schemaRules(Functions.cast(type), type, labelId, predicate);
    }

    public <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final Class<R> ruleType, final int labelId, final Predicate<R> predicate) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            public boolean test(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind().getRuleClass() == ruleType && predicate.test((Object)rule);
            }
        }, this.loadAllSchemaRules()));
    }

    public <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final SchemaRule.Kind kind, final Predicate<R> predicate) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            public boolean test(SchemaRule rule) {
                return rule.getKind() == kind && predicate.test((Object)rule);
            }
        }, this.loadAllSchemaRules()));
    }

    public <R extends SchemaRule> Iterator<R> schemaRules(final Class<R> ruleClass) {
        Iterator<SchemaRule> result = Iterables.filter(new Predicate<SchemaRule>(){

            public boolean test(SchemaRule rule) {
                return ruleClass.isInstance(rule);
            }
        }, this.loadAllSchemaRules());
        return result;
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return new PrefetchingIterator<SchemaRule>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            {
                this.highestId = SchemaStorage.this.schemaStore.getHighestPossibleIdInUse();
                this.currentId = 1L;
                this.scratchData = SchemaStorage.this.newRecordBuffer();
            }

            @Override
            protected SchemaRule fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    long id;
                    ++this.currentId;
                    DynamicRecord record = (DynamicRecord)SchemaStorage.this.schemaStore.forceGetRecord(id);
                    if (!record.inUse() || !record.isStartRecord()) continue;
                    try {
                        return SchemaStorage.this.getSchemaRule(id, this.scratchData);
                    }
                    catch (MalformedSchemaRuleException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId) throws MalformedSchemaRuleException {
        return this.getSchemaRule(ruleId, this.newRecordBuffer());
    }

    private byte[] newRecordBuffer() {
        return new byte[this.schemaStore.getRecordSize() * 4];
    }

    private SchemaRule getSchemaRule(long id, byte[] buffer) throws MalformedSchemaRuleException {
        Collection<DynamicRecord> records;
        try {
            records = this.schemaStore.getRecords(id);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e.getMessage(), e);
        }
        return SchemaStore.readSchemaRule(id, records, buffer);
    }

    public long newRuleId() {
        return this.schemaStore.nextId();
    }

    public UniquenessConstraintRule uniquenessConstraint(int labelId, final int propertyKeyId) throws SchemaRuleNotFoundException {
        Iterator<UniquenessConstraintRule> rules = this.schemaRules(UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            public boolean test(UniquenessConstraintRule item) {
                return item.containsPropertyKeyId(propertyKeyId);
            }
        });
        if (!rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "not found");
        }
        UniquenessConstraintRule rule = rules.next();
        if (rules.hasNext()) {
            throw new SchemaRuleNotFoundException(labelId, propertyKeyId, "found more than one matching index");
        }
        return rule;
    }

    public static enum IndexRuleKind {
        INDEX{

            @Override
            public boolean isOfKind(IndexRule rule) {
                return !rule.isConstraintIndex();
            }
        }
        ,
        CONSTRAINT{

            @Override
            public boolean isOfKind(IndexRule rule) {
                return rule.isConstraintIndex();
            }
        }
        ,
        ALL{

            @Override
            public boolean isOfKind(IndexRule rule) {
                return true;
            }
        };


        public abstract boolean isOfKind(IndexRule var1);
    }
}

