/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.logging.Logger;

class RWLock {
    private final Object resource;
    private final LinkedList<WaitElement> waitingThreadList = new LinkedList();
    private final ArrayMap<Object, TxLockElement> txLockElementMap = new ArrayMap(5, false, true);
    private final RagManager ragManager;
    private int totalReadCount;
    private int totalWriteCount;
    private int marked;

    RWLock(Object resource, RagManager ragManager) {
        this.resource = resource;
        this.ragManager = ragManager;
    }

    public Object resource() {
        return this.resource;
    }

    synchronized void mark() {
        ++this.marked;
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireReadLock(Object tx) throws DeadlockDetectedException {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            boolean shouldAddWait = true;
            Thread currentThread = Thread.currentThread();
            while (this.totalWriteCount > tle.writeCount) {
                this.ragManager.checkWaitOn(this, tx);
                if (shouldAddWait) {
                    this.waitingThreadList.addFirst(new WaitElement(tle, LockType.READ, currentThread));
                }
                try {
                    this.wait();
                    shouldAddWait = false;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    shouldAddWait = true;
                }
                this.ragManager.stopWaitOn(this, tx);
            }
            this.registerReadLockAcquired(tx, tle);
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireReadLock(Object tx) {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            if (this.totalWriteCount > tle.writeCount) {
                boolean bl = false;
                return bl;
            }
            this.registerReadLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    synchronized void releaseReadLock(Object tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx);
        if (tle.readCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have readLock");
        }
        --this.totalReadCount;
        tle.readCount--;
        if (tle.isFree()) {
            this.txLockElementMap.remove(tx);
            this.ragManager.lockReleased(this, tx);
        }
        if (this.waitingThreadList.size() > 0) {
            WaitElement we = this.waitingThreadList.getLast();
            if (we.lockType == LockType.WRITE) {
                if (this.totalReadCount == we.element.readCount) {
                    this.waitingThreadList.removeLast();
                    if (!we.element.movedOn) {
                        we.waitingThread.interrupt();
                    }
                } else {
                    ListIterator<WaitElement> listItr = this.waitingThreadList.listIterator(this.waitingThreadList.lastIndexOf(we));
                    while (listItr.hasPrevious()) {
                        we = listItr.previous();
                        if (we.lockType == LockType.WRITE && this.totalReadCount == we.element.readCount) {
                            listItr.remove();
                            if (we.element.movedOn) continue;
                            we.waitingThread.interrupt();
                            break;
                        }
                        if (we.lockType != LockType.READ) continue;
                        listItr.remove();
                        if (we.element.movedOn) continue;
                        we.waitingThread.interrupt();
                    }
                }
            } else if (this.totalWriteCount == 0) {
                this.waitingThreadList.removeLast();
                if (!we.element.movedOn) {
                    we.waitingThread.interrupt();
                }
            }
        }
    }

    void acquireWriteLock() throws DeadlockDetectedException {
        this.acquireWriteLock(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireWriteLock(Object tx) throws DeadlockDetectedException {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            boolean shouldAddWait = true;
            Thread currentThread = Thread.currentThread();
            while (this.totalWriteCount > tle.writeCount || this.totalReadCount > tle.readCount) {
                this.ragManager.checkWaitOn(this, tx);
                if (shouldAddWait) {
                    this.waitingThreadList.addFirst(new WaitElement(tle, LockType.WRITE, currentThread));
                }
                try {
                    this.wait();
                    shouldAddWait = false;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    shouldAddWait = true;
                }
                this.ragManager.stopWaitOn(this, tx);
            }
            this.registerWriteLockAcquired(tx, tle);
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireWriteLock(Object tx) {
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            if (this.totalWriteCount > tle.writeCount || this.totalReadCount > tle.readCount) {
                boolean bl = false;
                return bl;
            }
            this.registerWriteLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    synchronized void releaseWriteLock(Object tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx);
        if (tle.writeCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have writeLock");
        }
        --this.totalWriteCount;
        tle.writeCount--;
        if (tle.isFree()) {
            this.txLockElementMap.remove(tx);
            this.ragManager.lockReleased(this, tx);
        }
        if (this.totalWriteCount == 0 && this.waitingThreadList.size() > 0) {
            do {
                WaitElement we;
                if ((we = this.waitingThreadList.removeLast()).element.movedOn) continue;
                we.waitingThread.interrupt();
                if (we.lockType == LockType.WRITE) break;
            } while (this.waitingThreadList.size() > 0);
        }
    }

    int getWriteCount() {
        return this.totalWriteCount;
    }

    int getReadCount() {
        return this.totalReadCount;
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }

    public synchronized boolean logTo(Logger logger) {
        logger.log("Total lock count: readCount=" + this.totalReadCount + " writeCount=" + this.totalWriteCount + " for " + this.resource);
        logger.log("Waiting list:");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            WaitElement we = (WaitElement)wElements.next();
            logger.log("[" + we.waitingThread + "(" + we.element.readCount + "r," + we.element.writeCount + "w)," + (Object)((Object)we.lockType) + "]");
            if (wElements.hasNext()) {
                logger.log(",");
                continue;
            }
            logger.log("");
        }
        logger.log("Locking transactions:");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            logger.log("" + tle.tx + "(" + tle.readCount + "r," + tle.writeCount + "w)");
        }
        return true;
    }

    public synchronized String describe() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" Total lock count: readCount=" + this.totalReadCount + " writeCount=" + this.totalWriteCount + " for " + this.resource + "\n").append("Waiting list:\n");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            WaitElement we = (WaitElement)wElements.next();
            sb.append("[" + we.waitingThread + "(" + we.element.readCount + "r," + we.element.writeCount + "w)," + (Object)((Object)we.lockType) + "]\n");
            if (!wElements.hasNext()) continue;
            sb.append(",");
        }
        sb.append("Locking transactions:\n");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            sb.append("" + tle.tx + "(" + tle.readCount + "r," + tle.writeCount + "w)\n");
        }
        return sb.toString();
    }

    public synchronized long maxWaitTime() {
        long max = 0L;
        for (WaitElement thread : this.waitingThreadList) {
            if (thread.since >= max) continue;
            max = thread.since;
        }
        return System.currentTimeMillis() - max;
    }

    public String toString() {
        return "RWLock[" + this.resource + ", hash=" + this.hashCode() + "]";
    }

    private void registerReadLockAcquired(Object tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        ++this.totalReadCount;
        tle.readCount++;
    }

    private void registerWriteLockAcquired(Object tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        ++this.totalWriteCount;
        tle.writeCount++;
    }

    private void registerLockAcquired(Object tx, TxLockElement tle) {
        if (tle.isFree()) {
            this.ragManager.lockAcquired(this, tx);
        }
    }

    private TxLockElement getLockElement(Object tx) {
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        return tle;
    }

    private void assertTransaction(Object tx) {
        if (tx == null) {
            throw new IllegalArgumentException();
        }
    }

    private TxLockElement getOrCreateLockElement(Object tx) {
        this.assertTransaction(tx);
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            tle = new TxLockElement(tx);
            this.txLockElementMap.put(tx, tle);
        }
        return tle;
    }

    synchronized Object getTxLockElementCount() {
        return this.txLockElementMap.size();
    }

    private static class WaitElement {
        private final TxLockElement element;
        private final LockType lockType;
        private final Thread waitingThread;
        private final long since = System.currentTimeMillis();

        WaitElement(TxLockElement element, LockType lockType, Thread thread) {
            this.element = element;
            this.lockType = lockType;
            this.waitingThread = thread;
        }
    }

    private static class TxLockElement {
        private final Object tx;
        private int readCount;
        private int writeCount;
        private boolean movedOn;

        TxLockElement(Object tx) {
            this.tx = tx;
        }

        boolean isFree() {
            return this.readCount == 0 && this.writeCount == 0;
        }
    }
}

