/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.LongFunction;
import org.neo4j.function.Supplier;
import org.neo4j.function.primitive.FunctionFromPrimitiveLong;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.Log;
import org.neo4j.tooling.GlobalGraphOperations;

public class GraphDatabaseFacade
implements GraphDatabaseAPI {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private static final long MAX_RELATIONSHIP_ID = IdType.RELATIONSHIP.getMaxValue();
    private boolean initialized = false;
    private ThreadToStatementContextBridge threadToTransactionBridge;
    private NodeManager nodeManager;
    private IndexManager indexManager;
    private Schema schema;
    private AvailabilityGuard availabilityGuard;
    private Log msgLog;
    private LifeSupport life;
    private Supplier<KernelAPI> kernel;
    private Supplier<QueryExecutionEngine> queryExecutor;
    private KernelEventHandlers kernelEventHandlers;
    private TransactionEventHandlers transactionEventHandlers;
    private long transactionStartTimeout;
    private DependencyResolver dependencies;
    private Supplier<StoreId> storeId;
    protected File storeDir;
    public PlatformModule platformModule;
    public EditionModule editionModule;
    public DataSourceModule dataSourceModule;

    public void init(PlatformModule platformModule, EditionModule editionModule, DataSourceModule dataSourceModule) {
        this.platformModule = platformModule;
        this.editionModule = editionModule;
        this.dataSourceModule = dataSourceModule;
        this.threadToTransactionBridge = dataSourceModule.threadToTransactionBridge;
        this.nodeManager = dataSourceModule.nodeManager;
        this.indexManager = dataSourceModule.indexManager;
        this.schema = dataSourceModule.schema;
        this.availabilityGuard = platformModule.availabilityGuard;
        this.msgLog = platformModule.logging.getInternalLog(this.getClass());
        this.life = platformModule.life;
        this.kernel = dataSourceModule.kernelAPI;
        this.queryExecutor = dataSourceModule.queryExecutor;
        this.kernelEventHandlers = dataSourceModule.kernelEventHandlers;
        this.transactionEventHandlers = dataSourceModule.transactionEventHandlers;
        this.transactionStartTimeout = editionModule.transactionStartTimeout;
        this.dependencies = platformModule.dependencies;
        this.storeId = dataSourceModule.storeId;
        this.storeDir = platformModule.storeDir;
        this.initialized = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node createNode() {
        try (Statement statement = this.threadToTransactionBridge.get();){
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(statement.dataWriteOperations().nodeCreate());
            return nodeProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node createNode(Label ... labels) {
        try (Statement statement = this.threadToTransactionBridge.get();){
            long nodeId = statement.dataWriteOperations().nodeCreate();
            for (Label label : labels) {
                int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(label.name());
                try {
                    statement.dataWriteOperations().nodeAddLabel(nodeId, labelId);
                }
                catch (EntityNotFoundException e) {
                    throw new NotFoundException("No node with id " + nodeId + " found.", e);
                }
            }
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(nodeId);
            return nodeProxy;
        }
        catch (ConstraintValidationKernelException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public Node getNodeById(long id) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new NotFoundException(String.format("Node %d not found", id), new EntityNotFoundException(EntityType.NODE, id));
        }
        try (Statement statement = this.threadToTransactionBridge.get();){
            if (!statement.readOperations().nodeExists(id)) {
                throw new NotFoundException(String.format("Node %d not found", id), new EntityNotFoundException(EntityType.NODE, id));
            }
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(id);
            return nodeProxy;
        }
    }

    @Override
    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > MAX_RELATIONSHIP_ID) {
            throw new NotFoundException(String.format("Relationship %d not found", id), new EntityNotFoundException(EntityType.RELATIONSHIP, id));
        }
        try (Statement statement = this.threadToTransactionBridge.get();){
            if (!statement.readOperations().relationshipExists(id)) {
                throw new NotFoundException(String.format("Relationship %d not found", id), new EntityNotFoundException(EntityType.RELATIONSHIP, id));
            }
            RelationshipProxy relationshipProxy = this.nodeManager.newRelationshipProxy(id);
            return relationshipProxy;
        }
    }

    @Override
    public IndexManager index() {
        return this.indexManager;
    }

    @Override
    public Schema schema() {
        this.threadToTransactionBridge.assertInUnterminatedTransaction();
        return this.schema;
    }

    @Override
    public boolean isAvailable(long timeout) {
        return this.availabilityGuard.isAvailable(timeout);
    }

    @Override
    public void shutdown() {
        if (this.initialized) {
            try {
                this.msgLog.info("Shutdown started");
                this.availabilityGuard.shutdown();
                this.life.shutdown();
            }
            catch (LifecycleException throwable) {
                this.msgLog.warn("Shutdown failed", (Throwable)throwable);
                throw throwable;
            }
        }
    }

    @Override
    public Transaction beginTx() {
        this.availabilityGuard.checkAvailability(this.transactionStartTimeout, TransactionFailureException.class);
        TopLevelTransaction topLevelTransaction = this.threadToTransactionBridge.getTopLevelTransactionBoundToThisThread(false);
        if (topLevelTransaction != null) {
            return new PlaceboTransaction(topLevelTransaction);
        }
        try {
            KernelTransaction transaction = ((KernelAPI)this.kernel.get()).newTransaction();
            topLevelTransaction = new TopLevelTransaction(transaction, this.threadToTransactionBridge);
            this.threadToTransactionBridge.bindTransactionToCurrentThread(topLevelTransaction);
            return topLevelTransaction;
        }
        catch (org.neo4j.kernel.api.exceptions.TransactionFailureException e) {
            throw new TransactionFailureException("Failure to begin transaction", e);
        }
    }

    @Override
    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    @Override
    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        this.availabilityGuard.checkAvailability(this.transactionStartTimeout, TransactionFailureException.class);
        try {
            return ((QueryExecutionEngine)this.queryExecutor.get()).executeQuery(query, parameters, QueryEngineProvider.embeddedSession());
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return GlobalGraphOperations.at(this).getAllNodes();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return GlobalGraphOperations.at(this).getAllRelationshipTypes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.registerKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.registerTransactionEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.unregisterTransactionEventHandler(handler);
    }

    @Override
    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        return this.nodesByLabelAndProperty(myLabel, key, value);
    }

    @Override
    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException();
            }
            Node node2 = node;
            return node2;
        }
    }

    @Override
    public ResourceIterator<Node> findNodes(Label myLabel) {
        return this.allNodesWithLabel(myLabel);
    }

    @Override
    public ResourceIterable<Node> findNodesByLabelAndProperty(final Label myLabel, final String key, final Object value) {
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                return GraphDatabaseFacade.this.nodesByLabelAndProperty(myLabel, key, value);
            }
        };
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(Label myLabel, String key, Object value) {
        Statement statement = this.threadToTransactionBridge.get();
        ReadOperations readOps = statement.readOperations();
        int propertyId = readOps.propertyKeyGetForName(key);
        int labelId = readOps.labelGetForName(myLabel.name());
        if (propertyId == -1 || labelId == -1) {
            statement.close();
            return IteratorUtil.emptyIterator();
        }
        IndexDescriptor descriptor = this.findAnyIndexByLabelAndProperty(readOps, propertyId, labelId);
        try {
            if (null != descriptor) {
                return this.map2nodes(readOps.nodesGetFromIndexLookup(descriptor, value), statement);
            }
        }
        catch (IndexNotFoundKernelException e) {
            // empty catch block
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(propertyId, value, statement, labelId);
    }

    private IndexDescriptor findAnyIndexByLabelAndProperty(ReadOperations readOps, int propertyId, int labelId) {
        try {
            IndexDescriptor descriptor = readOps.indexesGetForLabelAndPropertyKey(labelId, propertyId);
            if (readOps.indexGetState(descriptor) == InternalIndexState.ONLINE) {
                return descriptor;
            }
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutIndex(int propertyId, Object value, Statement statement, int labelId) {
        return this.map2nodes((PrimitiveLongIterator)new PropertyValueFilteringNodeIdIterator(statement.readOperations().nodesGetForLabel(labelId), statement.readOperations(), propertyId, value), statement);
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        Statement statement = this.threadToTransactionBridge.get();
        int labelId = statement.readOperations().labelGetForName(myLabel.name());
        if (labelId == -1) {
            statement.close();
            return IteratorUtil.emptyIterator();
        }
        PrimitiveLongIterator nodeIds = statement.readOperations().nodesGetForLabel(labelId);
        return ResourceClosingIterator.newResourceIterator(statement, PrimitiveLongCollections.map((FunctionFromPrimitiveLong)new LongFunction<Node>(){

            public Node apply(long nodeId) {
                return GraphDatabaseFacade.this.nodeManager.newNodeProxyById(nodeId);
            }
        }, (PrimitiveLongIterator)nodeIds));
    }

    private ResourceIterator<Node> map2nodes(PrimitiveLongIterator input, Statement statement) {
        return ResourceClosingIterator.newResourceIterator(statement, PrimitiveLongCollections.map((FunctionFromPrimitiveLong)new LongFunction<Node>(){

            public Node apply(long id) {
                return GraphDatabaseFacade.this.getNodeById(id);
            }
        }, (PrimitiveLongIterator)input));
    }

    @Override
    public TraversalDescription traversalDescription() {
        return new MonoDirectionalTraversalDescription(this.threadToTransactionBridge);
    }

    @Override
    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return new BidirectionalTraversalDescriptionImpl(this.threadToTransactionBridge);
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.dependencies;
    }

    @Override
    public StoreId storeId() {
        return (StoreId)this.storeId.get();
    }

    @Override
    public String getStoreDir() {
        return this.storeDir.toString();
    }

    public String toString() {
        return this.platformModule.config.get(GraphDatabaseFacadeFactory.Configuration.editionName) + " [" + this.storeDir + "]";
    }

    private static class PropertyValueFilteringNodeIdIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
        private final PrimitiveLongIterator nodesWithLabel;
        private final ReadOperations statement;
        private final int propertyKeyId;
        private final Object value;

        PropertyValueFilteringNodeIdIterator(PrimitiveLongIterator nodesWithLabel, ReadOperations statement, int propertyKeyId, Object value) {
            this.nodesWithLabel = nodesWithLabel;
            this.statement = statement;
            this.propertyKeyId = propertyKeyId;
            this.value = value;
        }

        protected boolean fetchNext() {
            boolean hasNext = this.nodesWithLabel.hasNext();
            while (hasNext) {
                long nextValue = this.nodesWithLabel.next();
                try {
                    if (this.statement.nodeGetProperty(nextValue, this.propertyKeyId).valueEquals(this.value)) {
                        return this.next(nextValue);
                    }
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
                hasNext = this.nodesWithLabel.hasNext();
            }
            return false;
        }
    }
}

