/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class CommunityEditionModule
extends EditionModule {
    public CommunityEditionModule(PlatformModule platformModule) {
        Dependencies deps = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        File storeDir = platformModule.storeDir;
        DataSourceManager dataSourceManager = platformModule.dataSourceManager;
        LifeSupport life = platformModule.life;
        GraphDatabaseFacade graphDatabaseFacade = platformModule.graphDatabaseFacade;
        this.lockManager = deps.satisfyDependency(CommunityEditionModule.createLockManager(config, logging));
        this.idGeneratorFactory = deps.satisfyDependency(this.createIdGeneratorFactory());
        this.propertyKeyTokenHolder = life.add(deps.satisfyDependency(new PropertyKeyTokenHolder(this.createPropertyKeyCreator(config, dataSourceManager, this.idGeneratorFactory))));
        this.labelTokenHolder = life.add(deps.satisfyDependency(new LabelTokenHolder(this.createLabelIdCreator(config, dataSourceManager, this.idGeneratorFactory))));
        this.relationshipTypeTokenHolder = life.add(deps.satisfyDependency(new RelationshipTypeTokenHolder(this.createRelationshipTypeCreator(config, dataSourceManager, this.idGeneratorFactory))));
        life.add(deps.satisfyDependency(this.createKernelData(fileSystem, storeDir, config, graphDatabaseFacade)));
        this.commitProcessFactory = CommunityEditionModule.createCommitProcessFactory();
        this.headerInformationFactory = this.createHeaderInformationFactory();
        this.schemaWriteGuard = this.createSchemaWriteGuard();
        this.transactionStartTimeout = config.get(GraphDatabaseSettings.transaction_start_timeout);
        this.upgradeConfiguration = new ConfigMapUpgradeConfiguration(config);
        this.registerRecovery(config.get(GraphDatabaseFacadeFactory.Configuration.editionName), life, deps);
        this.publishEditionInfo(deps.resolveDependency(UsageData.class));
    }

    private void publishEditionInfo(UsageData sysInfo) {
        sysInfo.set(UsageDataKeys.edition, this.determineEdition());
        sysInfo.set(UsageDataKeys.operationalMode, UsageDataKeys.OperationalMode.single);
    }

    private UsageDataKeys.Edition determineEdition() {
        try {
            this.getClass().getClassLoader().loadClass("org.neo4j.kernel.ha.HighlyAvailableGraphDatabase");
            return UsageDataKeys.Edition.enterprise;
        }
        catch (ClassNotFoundException e) {
            try {
                this.getClass().getClassLoader().loadClass("org.neo4j.management.Neo4jManager");
                return UsageDataKeys.Edition.advanced;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return UsageDataKeys.Edition.community;
            }
        }
    }

    public static CommitProcessFactory createCommitProcessFactory() {
        return new CommitProcessFactory(){

            @Override
            public TransactionCommitProcess create(TransactionAppender appender, KernelHealth kernelHealth, NeoStore neoStore, TransactionRepresentationStoreApplier storeApplier, NeoStoreInjectedTransactionValidator txValidator, IndexUpdatesValidator indexUpdatesValidator, TransactionApplicationMode mode, Config config) {
                if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
                    return new ReadOnlyTransactionCommitProcess();
                }
                return new TransactionRepresentationCommitProcess(appender, kernelHealth, neoStore, storeApplier, indexUpdatesValidator, mode);
            }
        };
    }

    protected SchemaWriteGuard createSchemaWriteGuard() {
        return new SchemaWriteGuard(){

            @Override
            public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
            }
        };
    }

    protected TokenCreator createRelationshipTypeCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultRelationshipTypeCreator(dataSourceManager, idGeneratorFactory);
    }

    protected TokenCreator createPropertyKeyCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultPropertyTokenCreator(dataSourceManager, idGeneratorFactory);
    }

    protected TokenCreator createLabelIdCreator(Config config, DataSourceManager dataSourceManager, IdGeneratorFactory idGeneratorFactory) {
        if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultLabelIdCreator(dataSourceManager, idGeneratorFactory);
    }

    protected KernelData createKernelData(FileSystemAbstraction fileSystem, File storeDir, Config config, GraphDatabaseAPI graphAPI) {
        return new DefaultKernelData(fileSystem, storeDir, config, graphAPI);
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        return new DefaultIdGeneratorFactory();
    }

    public static Locks createLockManager(Config config, LogService logging) {
        String key = config.get(GraphDatabaseFacadeFactory.Configuration.lock_manager);
        for (Locks.Factory candidate : Service.load(Locks.Factory.class)) {
            String candidateId = candidate.getKeys().iterator().next();
            if (candidateId.equals(key)) {
                return candidate.newInstance(ResourceTypes.values());
            }
            if (!key.equals("")) continue;
            logging.getInternalLog(CommunityFacadeFactory.class).info("No locking implementation specified, defaulting to '" + candidateId + "'");
            return candidate.newInstance(ResourceTypes.values());
        }
        if (key.equals("community")) {
            return new CommunityLockManger();
        }
        if (key.equals("")) {
            logging.getInternalLog(CommunityFacadeFactory.class).info("No locking implementation specified, defaulting to 'community'");
            return new CommunityLockManger();
        }
        throw new IllegalArgumentException("No lock manager found with the name '" + key + "'.");
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return TransactionHeaderInformationFactory.DEFAULT;
    }

    protected void registerRecovery(final String editionName, LifeSupport life, final DependencyResolver dependencyResolver) {
        life.addLifecycleListener(new LifecycleListener(){

            @Override
            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance instanceof DatabaseAvailability && to.equals((Object)LifecycleStatus.STARTED)) {
                    CommunityEditionModule.this.doAfterRecoveryAndStartup(editionName, dependencyResolver);
                }
            }
        });
    }

    @Override
    protected void doAfterRecoveryAndStartup(String editionName, DependencyResolver dependencyResolver) {
        super.doAfterRecoveryAndStartup(editionName, dependencyResolver);
        new RemoveOrphanConstraintIndexesOnStartup(dependencyResolver.resolveDependency(NeoStoreDataSource.class).getKernel(), dependencyResolver.resolveDependency(LogService.class).getInternalLogProvider()).perform();
    }

    protected final class DefaultKernelData
    extends KernelData
    implements Lifecycle {
        private final GraphDatabaseAPI graphDb;

        public DefaultKernelData(FileSystemAbstraction fileSystem, File storeDir, Config config, GraphDatabaseAPI graphDb) {
            super(fileSystem, storeDir, config);
            this.graphDb = graphDb;
        }

        @Override
        public Version version() {
            return Version.getKernel();
        }

        @Override
        public GraphDatabaseAPI graphDatabase() {
            return this.graphDb;
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }
    }
}

