/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.impl.cache.HitCounter;

public class LruCache<K, E> {
    private final String name;
    private int maxSize;
    private final Map<K, E> cache = new LinkedHashMap<K, E>(500, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, E> eldest) {
            if (this.size() > LruCache.this.maxSize) {
                LruCache.this.elementCleaned(eldest.getValue());
                return true;
            }
            return false;
        }
    };
    private final HitCounter counter = new HitCounter();

    public LruCache(String name, int maxSize) {
        if (name == null || maxSize < 1) {
            throw new IllegalArgumentException("maxSize=" + maxSize + ", name=" + name);
        }
        this.name = name;
        this.maxSize = maxSize;
    }

    public String getName() {
        return this.name;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public synchronized void put(K key, E element) {
        if (key == null || element == null) {
            throw new IllegalArgumentException("key=" + key + ", element=" + element);
        }
        this.cache.put(key, element);
    }

    public synchronized E remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        return this.cache.remove(key);
    }

    public synchronized E get(K key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.counter.count(this.cache.get(key));
    }

    public synchronized void clear() {
        for (Map.Entry<K, E> keEntry : this.cache.entrySet()) {
            this.elementCleaned(keEntry.getValue());
        }
        this.cache.clear();
    }

    public synchronized int size() {
        return this.cache.size();
    }

    public synchronized Set<K> keySet() {
        return this.cache.keySet();
    }

    public synchronized Collection<E> values() {
        return this.cache.values();
    }

    public synchronized Set<Map.Entry<K, E>> entrySet() {
        return this.cache.entrySet();
    }

    public synchronized void putAll(Map<K, E> map) {
        this.cache.putAll(map);
    }

    public synchronized void resize(int newMaxSize) {
        if (newMaxSize < 1) {
            throw new IllegalArgumentException("newMaxSize=" + newMaxSize);
        }
        if (newMaxSize >= this.size()) {
            this.maxSize = newMaxSize;
        } else {
            this.maxSize = newMaxSize;
            Iterator<Map.Entry<K, E>> itr = this.cache.entrySet().iterator();
            while (itr.hasNext() && this.cache.size() > this.maxSize) {
                E element = itr.next().getValue();
                itr.remove();
                this.elementCleaned(element);
            }
        }
    }

    public void elementCleaned(E element) {
    }

    public long hitCount() {
        return this.counter.getHitsCount();
    }

    public long missCount() {
        return this.counter.getMissCount();
    }
}

