/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.function.BiConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.AggregatedReservation;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxySetup;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingControllerFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class IndexingService
extends LifecycleAdapter {
    private final IndexSamplingController samplingController;
    private final IndexProxySetup proxySetup;
    private final IndexStoreView storeView;
    private final SchemaIndexProviderMap providerMap;
    private final IndexMapReference indexMapRef;
    private final Iterable<IndexRule> indexRules;
    private final Log log;
    private final TokenNameLookup tokenNameLookup;
    private final Monitor monitor;
    private final PrimitiveLongSet recoveredNodeIds = Primitive.longSet((int)20);
    public static final Monitor NO_MONITOR = new MonitorAdapter(){};
    private volatile State state = State.NOT_STARTED;

    protected IndexingService(IndexProxySetup proxySetup, SchemaIndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreView storeView, Iterable<IndexRule> indexRules, IndexSamplingController samplingController, TokenNameLookup tokenNameLookup, LogProvider logProvider, Monitor monitor) {
        this.proxySetup = proxySetup;
        this.providerMap = providerMap;
        this.indexMapRef = indexMapRef;
        this.storeView = storeView;
        this.indexRules = indexRules;
        this.samplingController = samplingController;
        this.tokenNameLookup = tokenNameLookup;
        this.monitor = monitor;
        this.log = logProvider.getLog(this.getClass());
    }

    public static IndexingService create(IndexSamplingConfig samplingConfig, JobScheduler scheduler, SchemaIndexProviderMap providerMap, IndexStoreView storeView, TokenNameLookup tokenNameLookup, UpdateableSchemaState updateableSchemaState, Iterable<IndexRule> indexRules, LogProvider logProvider, Monitor monitor) {
        if (providerMap == null || providerMap.getDefaultProvider() == null) {
            throw new IllegalStateException("You cannot run the database without an index provider, please make sure that a valid provider (subclass of " + SchemaIndexProvider.class.getName() + ") is on your classpath.");
        }
        IndexMapReference indexMapRef = new IndexMapReference();
        IndexSamplingControllerFactory factory = new IndexSamplingControllerFactory(samplingConfig, storeView, scheduler, tokenNameLookup, logProvider);
        IndexSamplingController indexSamplingController = factory.create(indexMapRef);
        IndexProxySetup proxySetup = new IndexProxySetup(samplingConfig, storeView, providerMap, updateableSchemaState, tokenNameLookup, scheduler, logProvider);
        return new IndexingService(proxySetup, providerMap, indexMapRef, storeView, indexRules, indexSamplingController, tokenNameLookup, logProvider, monitor);
    }

    @Override
    public void init() {
        IndexMap indexMap = this.indexMapRef.indexMapSnapshot();
        for (IndexRule indexRule : this.indexRules) {
            IndexProxy indexProxy;
            long indexId = indexRule.getId();
            IndexDescriptor descriptor = new IndexDescriptor(indexRule.getLabel(), indexRule.getPropertyKey());
            SchemaIndexProvider.Descriptor providerDescriptor = indexRule.getProviderDescriptor();
            SchemaIndexProvider provider = this.providerMap.apply(providerDescriptor);
            InternalIndexState initialState = provider.getInitialState(indexId);
            this.log.info(this.proxySetup.indexStateInfo("init", indexId, initialState, descriptor));
            boolean constraint = indexRule.isConstraintIndex();
            switch (initialState) {
                case ONLINE: {
                    indexProxy = this.proxySetup.createOnlineIndexProxy(indexId, descriptor, providerDescriptor, constraint);
                    break;
                }
                case POPULATING: {
                    indexProxy = this.proxySetup.createRecoveringIndexProxy(descriptor, providerDescriptor, constraint);
                    break;
                }
                case FAILED: {
                    IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(indexId));
                    indexProxy = this.proxySetup.createFailedIndexProxy(indexId, descriptor, providerDescriptor, constraint, failure);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("" + (Object)((Object)initialState));
                }
            }
            indexMap.putIndexProxy(indexId, indexProxy);
        }
        this.indexMapRef.setIndexMap(indexMap);
    }

    @Override
    public void start() throws IOException {
        this.state = State.STARTING;
        this.applyRecoveredUpdates();
        IndexMap indexMap = this.indexMapRef.indexMapSnapshot();
        final HashMap<Long, Pair<IndexDescriptor, SchemaIndexProvider.Descriptor>> rebuildingDescriptors = new HashMap<Long, Pair<IndexDescriptor, SchemaIndexProvider.Descriptor>>();
        indexMap.foreachIndexProxy(new BiConsumer<Long, IndexProxy>(){

            public void accept(Long indexId, IndexProxy proxy) {
                InternalIndexState state = proxy.getState();
                IndexDescriptor descriptor = proxy.getDescriptor();
                IndexingService.this.log.info(IndexingService.this.proxySetup.indexStateInfo("start", indexId, state, descriptor));
                switch (state) {
                    case ONLINE: {
                        break;
                    }
                    case POPULATING: {
                        rebuildingDescriptors.put(indexId, Pair.of(descriptor, proxy.getProviderDescriptor()));
                        break;
                    }
                }
            }
        });
        this.dropRecoveringIndexes(indexMap, rebuildingDescriptors);
        for (Map.Entry entry : rebuildingDescriptors.entrySet()) {
            long indexId = (Long)entry.getKey();
            Pair descriptors = (Pair)entry.getValue();
            IndexDescriptor indexDescriptor = (IndexDescriptor)descriptors.first();
            SchemaIndexProvider.Descriptor providerDescriptor = (SchemaIndexProvider.Descriptor)descriptors.other();
            IndexProxy proxy = this.proxySetup.createPopulatingIndexProxy(indexId, indexDescriptor, providerDescriptor, false, this.monitor);
            proxy.start();
            indexMap.putIndexProxy(indexId, proxy);
        }
        this.indexMapRef.setIndexMap(indexMap);
        this.samplingController.recoverIndexSamples();
        this.samplingController.start();
        this.state = State.RUNNING;
    }

    @Override
    public void stop() {
        this.state = State.STOPPED;
        this.closeAllIndexes();
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(long indexId) throws IndexNotFoundKernelException {
        IndexProxy indexProxy = this.indexMapRef.getOnlineIndexProxy(indexId);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexUpdatesAndSize(indexProxy.getDescriptor(), output);
        return output;
    }

    public long indexSize(long indexId) throws IndexNotFoundKernelException {
        IndexProxy indexProxy = this.indexMapRef.getOnlineIndexProxy(indexId);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexSample(indexProxy.getDescriptor(), output);
        return output.readSecond();
    }

    public double indexUniqueValuesPercentage(long indexId) throws IndexNotFoundKernelException {
        IndexProxy indexProxy = this.indexMapRef.getOnlineIndexProxy(indexId);
        Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
        this.storeView.indexSample(indexProxy.getDescriptor(), output);
        long unique = output.readFirst();
        long size = output.readSecond();
        if (size == 0L) {
            return 1.0;
        }
        return (double)unique / (double)size;
    }

    public void createIndex(IndexRule rule) {
        long ruleId;
        IndexMap indexMap = this.indexMapRef.indexMapSnapshot();
        IndexProxy index = indexMap.getIndexProxy(ruleId = rule.getId());
        if (index != null && this.state == State.NOT_STARTED) {
            indexMap.putIndexProxy(ruleId, index);
            this.indexMapRef.setIndexMap(indexMap);
            return;
        }
        IndexDescriptor descriptor = new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
        SchemaIndexProvider.Descriptor providerDescriptor = rule.getProviderDescriptor();
        boolean constraint = rule.isConstraintIndex();
        if (this.state == State.RUNNING) {
            try {
                index = this.proxySetup.createPopulatingIndexProxy(ruleId, descriptor, providerDescriptor, constraint, this.monitor);
                index.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            index = this.proxySetup.createRecoveringIndexProxy(descriptor, providerDescriptor, constraint);
        }
        indexMap.putIndexProxy(rule.getId(), index);
        this.indexMapRef.setIndexMap(indexMap);
    }

    public void addRecoveredNodeIds(PrimitiveLongSet nodeIds) {
        if (this.state != State.NOT_STARTED) {
            throw new IllegalStateException("Can't queue recovered node ids " + nodeIds + " while indexing service is " + (Object)((Object)this.state));
        }
        this.recoveredNodeIds.addAll(nodeIds.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatedIndexUpdates validate(Iterable<NodePropertyUpdate> updates) {
        IndexUpdateMode updateMode;
        if (this.state == State.RUNNING) {
            updateMode = IndexUpdateMode.ONLINE;
        } else if (this.state == State.STARTING) {
            updateMode = IndexUpdateMode.RECOVERY;
        } else {
            throw new IllegalStateException("Can't validate index updates " + Iterables.toList(updates) + " while indexing service is " + (Object)((Object)this.state));
        }
        IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(updateMode);
        boolean updaterMapShouldBeClosed = true;
        try {
            Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex = IndexingService.groupUpdatesByIndexDescriptor(updates, updaterMap);
            if (updatesByIndex.isEmpty()) {
                ValidatedIndexUpdates validatedIndexUpdates = ValidatedIndexUpdates.NONE;
                return validatedIndexUpdates;
            }
            AggregatedReservation aggregatedReservation = new AggregatedReservation(updatesByIndex.size());
            for (Map.Entry<IndexDescriptor, List<NodePropertyUpdate>> entry : updatesByIndex.entrySet()) {
                this.validateAndRecordReservation(entry.getValue(), aggregatedReservation, updaterMap, entry.getKey());
            }
            ValidatedIndexUpdates validatedUpdates = IndexingService.newValidatedIndexUpdates(updaterMap, updatesByIndex, aggregatedReservation);
            updaterMapShouldBeClosed = false;
            ValidatedIndexUpdates validatedIndexUpdates = validatedUpdates;
            return validatedIndexUpdates;
        }
        finally {
            if (updaterMapShouldBeClosed) {
                updaterMap.close();
            }
        }
    }

    private void validateAndRecordReservation(List<NodePropertyUpdate> indexUpdates, AggregatedReservation aggregatedReservation, IndexUpdaterMap updaterMap, IndexDescriptor descriptor) {
        boolean exceptionThrown = false;
        try {
            IndexUpdater updater = updaterMap.getUpdater(descriptor);
            Reservation reservation = updater.validate(indexUpdates);
            aggregatedReservation.add(reservation);
        }
        catch (IOException | IndexCapacityExceededException e) {
            exceptionThrown = true;
            String indexName = descriptor.userDescription(this.tokenNameLookup);
            throw new UnderlyingStorageException("Validation of updates for index " + indexName + " failed", e);
        }
        catch (Throwable t) {
            exceptionThrown = true;
            throw t;
        }
        finally {
            if (exceptionThrown) {
                aggregatedReservation.release();
            }
        }
    }

    private static ValidatedIndexUpdates newValidatedIndexUpdates(final IndexUpdaterMap indexUpdaters, final Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex, final Reservation reservation) {
        return new ValidatedIndexUpdates(){

            @Override
            public void flush() throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
                for (Map.Entry entry : updatesByIndex.entrySet()) {
                    IndexDescriptor indexDescriptor = (IndexDescriptor)entry.getKey();
                    List updates = (List)entry.getValue();
                    IndexUpdater updater = indexUpdaters.getUpdater(indexDescriptor);
                    for (NodePropertyUpdate update : updates) {
                        updater.process(update);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    reservation.release();
                }
                finally {
                    indexUpdaters.close();
                }
            }

            @Override
            public boolean hasChanges() {
                return !updatesByIndex.isEmpty();
            }
        };
    }

    private void applyRecoveredUpdates() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Applying recovered updates: " + this.recoveredNodeIds);
        }
        this.monitor.applyingRecoveredData(this.recoveredNodeIds);
        if (!this.recoveredNodeIds.isEmpty()) {
            try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(IndexUpdateMode.RECOVERY);){
                for (IndexUpdater updater : updaterMap) {
                    updater.remove(this.recoveredNodeIds);
                }
            }
            List<NodePropertyUpdate> recoveredUpdates = this.readRecoveredUpdatesFromStore();
            try (ValidatedIndexUpdates validatedUpdates = this.validate(recoveredUpdates);){
                validatedUpdates.flush();
                this.monitor.appliedRecoveredData(recoveredUpdates);
            }
            catch (IndexCapacityExceededException | IndexEntryConflictException e) {
                throw new UnderlyingStorageException(e);
            }
        }
        this.recoveredNodeIds.clear();
    }

    private List<NodePropertyUpdate> readRecoveredUpdatesFromStore() {
        final ArrayList<NodePropertyUpdate> recoveredUpdates = new ArrayList<NodePropertyUpdate>();
        this.recoveredNodeIds.visitKeys((PrimitiveLongVisitor)new PrimitiveLongVisitor<RuntimeException>(){

            public boolean visited(long nodeId) {
                Iterables.addAll(recoveredUpdates, IndexingService.this.storeView.nodeAsUpdates(nodeId));
                return false;
            }
        });
        return recoveredUpdates;
    }

    private static Map<IndexDescriptor, List<NodePropertyUpdate>> groupUpdatesByIndexDescriptor(Iterable<NodePropertyUpdate> updates, IndexUpdaterMap updaterMap) {
        int numberOfIndexes = updaterMap.numberOfIndexes();
        HashMap<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex = new HashMap<IndexDescriptor, List<NodePropertyUpdate>>(numberOfIndexes, 1.0f);
        block5: for (NodePropertyUpdate update : updates) {
            int propertyKeyId = update.getPropertyKeyId();
            switch (update.getUpdateMode()) {
                case ADDED: {
                    int i;
                    int len = update.getNumberOfLabelsAfter();
                    for (i = 0; i < len; ++i) {
                        IndexDescriptor descriptor = new IndexDescriptor(update.getLabelAfter(i), propertyKeyId);
                        IndexingService.storeUpdateIfIndexExists(updaterMap, update, descriptor, updatesByIndex);
                    }
                    continue block5;
                }
                case REMOVED: {
                    int i;
                    int len = update.getNumberOfLabelsBefore();
                    for (i = 0; i < len; ++i) {
                        IndexDescriptor descriptor = new IndexDescriptor(update.getLabelBefore(i), propertyKeyId);
                        IndexingService.storeUpdateIfIndexExists(updaterMap, update, descriptor, updatesByIndex);
                    }
                    continue block5;
                }
                case CHANGED: {
                    int lenBefore = update.getNumberOfLabelsBefore();
                    int lenAfter = update.getNumberOfLabelsAfter();
                    int i = 0;
                    int j = 0;
                    while (i < lenBefore && j < lenAfter) {
                        int labelAfter;
                        int labelBefore = update.getLabelBefore(i);
                        if (labelBefore == (labelAfter = update.getLabelAfter(j))) {
                            IndexDescriptor descriptor = new IndexDescriptor(labelAfter, propertyKeyId);
                            IndexingService.storeUpdateIfIndexExists(updaterMap, update, descriptor, updatesByIndex);
                            ++i;
                            ++j;
                            continue;
                        }
                        if (labelBefore < labelAfter) {
                            ++i;
                            continue;
                        }
                        ++j;
                    }
                    break;
                }
            }
        }
        return updatesByIndex;
    }

    private static void storeUpdateIfIndexExists(IndexUpdaterMap updaterMap, NodePropertyUpdate update, IndexDescriptor descriptor, Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex) {
        IndexUpdater updater = updaterMap.getUpdater(descriptor);
        if (updater != null) {
            List<NodePropertyUpdate> indexUpdates = updatesByIndex.get(descriptor);
            if (indexUpdates == null) {
                indexUpdates = new ArrayList<NodePropertyUpdate>();
                updatesByIndex.put(descriptor, indexUpdates);
            }
            indexUpdates.add(update);
        }
    }

    public void dropIndex(IndexRule rule) {
        long indexId = rule.getId();
        IndexProxy index = this.indexMapRef.removeIndexProxy(indexId);
        if (this.state == State.RUNNING) {
            assert (index != null) : "Index " + rule + " doesn't exists";
            try {
                Future<Void> dropFuture = index.drop();
                this.awaitIndexFuture(dropFuture);
            }
            catch (Exception e) {
                throw Exceptions.launderedException(e);
            }
        }
    }

    public void triggerIndexSampling(IndexSamplingMode mode) {
        this.log.info("Manual trigger for sampling all indexes [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndexes(mode);
    }

    public void triggerIndexSampling(IndexDescriptor descriptor, IndexSamplingMode mode) {
        String description = descriptor.userDescription(this.tokenNameLookup);
        this.log.info("Manual trigger for sampling index " + description + " [" + (Object)((Object)mode) + "]");
        this.samplingController.sampleIndex(descriptor, mode);
    }

    private void awaitIndexFuture(Future<Void> future) throws Exception {
        try {
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw e;
        }
    }

    private void dropRecoveringIndexes(IndexMap indexMap, Map<Long, Pair<IndexDescriptor, SchemaIndexProvider.Descriptor>> recoveringIndexes) throws IOException {
        for (long indexId : recoveringIndexes.keySet()) {
            IndexProxy indexProxy = indexMap.removeIndexProxy(indexId);
            indexProxy.drop();
        }
    }

    public void activateIndex(long indexId) throws IndexNotFoundKernelException, IndexActivationFailedKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getIndexProxy(indexId);
                index.awaitStoreScanCompleted();
                index.activate();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IndexActivationFailedKernelException(e, "Unable to activate index, thread was interrupted.");
        }
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(indexId);
    }

    public void validateIndex(long indexId) throws IndexNotFoundKernelException, ConstraintVerificationFailedKernelException, IndexPopulationFailedKernelException {
        this.getIndexProxy(indexId).validate();
    }

    public void flushAll() {
        for (IndexProxy index : this.indexMapRef.getAllIndexProxies()) {
            try {
                index.force();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to force " + index, e);
            }
        }
    }

    private void closeAllIndexes() {
        Iterable<IndexProxy> indexesToStop = this.indexMapRef.clear();
        ArrayList<Future<Void>> indexStopFutures = new ArrayList<Future<Void>>();
        for (IndexProxy indexProxy : indexesToStop) {
            try {
                indexStopFutures.add(indexProxy.close());
            }
            catch (IOException e) {
                this.log.error("Unable to close index", (Throwable)e);
            }
        }
        for (Future future : indexStopFutures) {
            try {
                this.awaitIndexFuture(future);
            }
            catch (Exception e) {
                this.log.error("Error awaiting index to close", (Throwable)e);
            }
        }
    }

    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        HashSet<SchemaIndexProvider.Descriptor> fromProviders = new HashSet<SchemaIndexProvider.Descriptor>();
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            SchemaIndexProvider.Descriptor providerDescriptor = indexProxy.getProviderDescriptor();
            if (fromProviders.add(providerDescriptor)) {
                snapshots.add(this.providerMap.apply(providerDescriptor).snapshotMetaFiles());
            }
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterables.concatResourceIterators(snapshots.iterator());
    }

    public static abstract class MonitorAdapter
    implements Monitor {
        @Override
        public void appliedRecoveredData(Iterable<NodePropertyUpdate> updates) {
        }

        @Override
        public void applyingRecoveredData(PrimitiveLongSet recoveredNodeIds) {
        }

        @Override
        public void populationCompleteOn(IndexDescriptor descriptor) {
        }

        @Override
        public void verifyDeferredConstraints() {
        }
    }

    public static interface Monitor {
        public void applyingRecoveredData(PrimitiveLongSet var1);

        public void appliedRecoveredData(Iterable<NodePropertyUpdate> var1);

        public void populationCompleteOn(IndexDescriptor var1);

        public void verifyDeferredConstraints();
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

