/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.LongPredicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.PropertyLookup;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;

public class LookupFilter {
    public static PrimitiveLongIterator exactIndexMatches(PropertyLookup lookup, PrimitiveLongIterator indexedNodeIds, int propertyKeyId, Object value) {
        if (LookupFilter.isNumberOrArray(value)) {
            return PrimitiveLongCollections.filter((PrimitiveLongIterator)indexedNodeIds, (LongPredicate)new LookupBasedExactMatchPredicate(lookup, propertyKeyId, value));
        }
        return indexedNodeIds;
    }

    public static PrimitiveLongIterator exactIndexMatches(EntityOperations operations, KernelStatement state, PrimitiveLongIterator indexedNodeIds, int propertyKeyId, Object value) {
        if (LookupFilter.isNumberOrArray(value)) {
            return PrimitiveLongCollections.filter((PrimitiveLongIterator)indexedNodeIds, (LongPredicate)new OperationsBasedExactMatchPredicate(operations, state, propertyKeyId, value));
        }
        return indexedNodeIds;
    }

    private static boolean isNumberOrArray(Object value) {
        return value instanceof Number || value.getClass().isArray();
    }

    private static class LookupBasedExactMatchPredicate
    extends BaseExactMatchPredicate {
        final PropertyLookup lookup;

        LookupBasedExactMatchPredicate(PropertyLookup lookup, int propertyKeyId, Object value) {
            super(propertyKeyId, value);
            this.lookup = lookup;
        }

        @Override
        Property nodeProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
            return this.lookup.nodeProperty(nodeId, propertyKeyId);
        }
    }

    private static class OperationsBasedExactMatchPredicate
    extends BaseExactMatchPredicate {
        final EntityReadOperations readOperations;
        final KernelStatement state;

        OperationsBasedExactMatchPredicate(EntityReadOperations readOperations, KernelStatement state, int propertyKeyId, Object value) {
            super(propertyKeyId, value);
            this.readOperations = readOperations;
            this.state = state;
        }

        @Override
        Property nodeProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
            return this.readOperations.nodeGetProperty(this.state, nodeId, propertyKeyId);
        }
    }

    private static abstract class BaseExactMatchPredicate
    implements LongPredicate {
        private final int propertyKeyId;
        private final Object value;

        BaseExactMatchPredicate(int propertyKeyId, Object value) {
            this.propertyKeyId = propertyKeyId;
            this.value = value;
        }

        public boolean test(long nodeId) {
            try {
                return this.nodeProperty(nodeId, this.propertyKeyId).valueEquals(this.value);
            }
            catch (EntityNotFoundException e) {
                throw new ThisShouldNotHappenError("Chris", "An index claims a node by id " + nodeId + " has the value. However, it looks like that node does not exist.", e);
            }
        }

        abstract Property nodeProperty(long var1, int var3) throws EntityNotFoundException;
    }
}

