/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.CharProperty;
import org.neo4j.kernel.api.properties.DefinedProperty;

final class StringProperty
extends DefinedProperty {
    private final String value;

    StringProperty(int propertyKeyId, String value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        return StringProperty.valueEquals(this.value, other);
    }

    static boolean valueEquals(String value, Object other) {
        if (other instanceof String) {
            return value.equals(other);
        }
        if (other instanceof Character) {
            Character that = (Character)other;
            return value.length() == 1 && value.charAt(0) == that.charValue();
        }
        return false;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    int valueHash() {
        return this.value.hashCode();
    }

    @Override
    boolean hasEqualValue(DefinedProperty other) {
        if (other instanceof StringProperty) {
            StringProperty that = (StringProperty)other;
            return this.value.equals(that.value);
        }
        if (other instanceof CharProperty) {
            CharProperty that = (CharProperty)other;
            return this.value.length() == 1 && that.value == this.value.charAt(0);
        }
        return false;
    }
}

