/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collection;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class UpdateRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<RECORD[]>
implements StatsProvider {
    private final RecordStore<RECORD> store;
    private final int recordSize;
    private int recordsUpdated;
    private final Predicate<RECORD> updatePredicate;

    public UpdateRecordsStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, RecordStore<RECORD> store) {
        this(control, config, store, Predicates.TRUE());
    }

    public UpdateRecordsStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, RecordStore<RECORD> store, Predicate<RECORD> updatePredicate) {
        super(control, "v", (Configuration)config, 1, new StatsProvider[0]);
        this.store = store;
        this.recordSize = store.getRecordSize();
        this.updatePredicate = updatePredicate;
    }

    @Override
    protected void process(RECORD[] batch, BatchSender sender) {
        for (Object record : batch) {
            if (((AbstractBaseRecord)record).inUse() && !this.updatePredicate.accept(record)) {
                record = ((AbstractBaseRecord)record).clone();
                ((AbstractBaseRecord)record).setInUse(false);
            }
            this.store.updateRecord(record);
        }
        this.recordsUpdated += batch.length;
    }

    @Override
    protected void collectStatsProviders(Collection<StatsProvider> into) {
        super.collectStatsProviders(into);
        into.add(this);
    }

    @Override
    public Stat stat(Key key) {
        return key == Keys.io_throughput ? new IoThroughputStat(this.startTime, this.endTime, this.recordSize * this.recordsUpdated) : null;
    }

    @Override
    public Key[] keys() {
        return new Keys[]{Keys.io_throughput};
    }
}

