/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipProcessor;
import org.neo4j.unsafe.impl.batchimport.ReadNodeRecordsStep;
import org.neo4j.unsafe.impl.batchimport.RecordProcessorStep;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class NodeFirstRelationshipStage
extends Stage {
    public NodeFirstRelationshipStage(Configuration config, NodeStore nodeStore, RelationshipGroupStore relationshipGroupStore, NodeRelationshipCache cache, Collector collector) {
        super("Node --> Relationship", config);
        this.add(new ReadNodeRecordsStep(this.control(), config, nodeStore));
        this.add(new RecordProcessorStep<NodeRecord>(this.control(), "LINK", config, new NodeFirstRelationshipProcessor(relationshipGroupStore, cache), false, new StatsProvider[0]));
        this.add(new UpdateRecordsStep<NodeRecord>(this.control(), config, nodeStore, this.deleteDuplicates(collector.leftOverDuplicateNodesIds())));
    }

    private Predicate<NodeRecord> deleteDuplicates(final PrimitiveLongIterator ids) {
        return !ids.hasNext() ? Predicates.TRUE() : new Predicate<NodeRecord>(){
            private long current;
            private boolean end;
            {
                this.current = ids.next();
            }

            @Override
            public boolean accept(NodeRecord node) {
                if (!this.end && this.current == node.getId()) {
                    boolean bl = this.end = !ids.hasNext();
                    if (!this.end) {
                        this.current = ids.next();
                    }
                    return false;
                }
                return true;
            }
        };
    }
}

