/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Visitable;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.tooling.GlobalGraphOperations;

public class GraphDbStructureGuide
implements Visitable<DbStructureVisitor> {
    private static RelationshipType WILDCARD_REL_TYPE = new RelationshipType(){

        @Override
        public String name() {
            return "";
        }
    };
    private final GraphDatabaseAPI db;
    private final ThreadToStatementContextBridge bridge;
    private final GlobalGraphOperations glops;

    public GraphDbStructureGuide(GraphDatabaseService graph) {
        this.db = (GraphDatabaseAPI)graph;
        DependencyResolver dependencyResolver = this.db.getDependencyResolver();
        this.bridge = dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
        this.glops = GlobalGraphOperations.at(this.db);
    }

    @Override
    public void accept(DbStructureVisitor visitor) {
        try (Transaction tx = this.db.beginTx();){
            try (Statement statement = this.bridge.get();){
                this.showStructure(statement, visitor);
            }
            tx.success();
        }
    }

    private void showStructure(Statement statement, DbStructureVisitor visitor) {
        ReadOperations read = statement.readOperations();
        try {
            this.showTokens(visitor, read);
            this.showSchema(visitor, read);
            this.showStatistics(visitor, read);
        }
        catch (KernelException e) {
            throw new IllegalStateException("Kernel exception when traversing database schema structure and statistics.  This is not expected to happen.", e);
        }
    }

    private void showTokens(DbStructureVisitor visitor, ReadOperations read) {
        this.showLabels(read, visitor);
        this.showPropertyKeys(read, visitor);
        this.showRelTypes(read, visitor);
    }

    private void showLabels(ReadOperations read, DbStructureVisitor visitor) {
        for (Label label : this.glops.getAllLabels()) {
            int labelId = read.labelGetForName(label.name());
            visitor.visitLabel(labelId, label.name());
        }
    }

    private void showPropertyKeys(ReadOperations read, DbStructureVisitor visitor) {
        for (String propertyKeyName : this.glops.getAllPropertyKeys()) {
            int propertyKeyId = read.propertyKeyGetForName(propertyKeyName);
            visitor.visitPropertyKey(propertyKeyId, propertyKeyName);
        }
    }

    private void showRelTypes(ReadOperations read, DbStructureVisitor visitor) {
        for (RelationshipType relType : this.glops.getAllRelationshipTypes()) {
            int relTypeId = read.relationshipTypeGetForName(relType.name());
            visitor.visitRelationshipType(relTypeId, relType.name());
        }
    }

    private void showSchema(DbStructureVisitor visitor, ReadOperations read) throws IndexNotFoundKernelException {
        StatementTokenNameLookup nameLookup = new StatementTokenNameLookup(read);
        this.showIndices(visitor, read, nameLookup);
        this.showUniqueIndices(visitor, read, nameLookup);
        this.showUniqueConstraints(visitor, read, nameLookup);
    }

    private void showIndices(DbStructureVisitor visitor, ReadOperations read, TokenNameLookup nameLookup) throws IndexNotFoundKernelException {
        Iterator<IndexDescriptor> indexDescriptors = read.indexesGetAll();
        while (indexDescriptors.hasNext()) {
            IndexDescriptor descriptor = indexDescriptors.next();
            String userDescription = descriptor.userDescription(nameLookup);
            double uniqueValuesPercentage = read.indexUniqueValuesSelectivity(descriptor);
            visitor.visitIndex(descriptor, userDescription, uniqueValuesPercentage);
        }
    }

    private void showUniqueIndices(DbStructureVisitor visitor, ReadOperations read, TokenNameLookup nameLookup) throws IndexNotFoundKernelException {
        Iterator<IndexDescriptor> indexDescriptors = read.uniqueIndexesGetAll();
        while (indexDescriptors.hasNext()) {
            IndexDescriptor descriptor = indexDescriptors.next();
            String userDescription = descriptor.userDescription(nameLookup);
            double uniqueValuesPercentage = read.indexUniqueValuesSelectivity(descriptor);
            visitor.visitUniqueIndex(descriptor, userDescription, uniqueValuesPercentage);
        }
    }

    private void showUniqueConstraints(DbStructureVisitor visitor, ReadOperations read, TokenNameLookup nameLookup) {
        Iterator<UniquenessConstraint> constraints = read.constraintsGetAll();
        while (constraints.hasNext()) {
            UniquenessConstraint constraint = constraints.next();
            String userDescription = constraint.userDescription(nameLookup);
            visitor.visitUniqueConstraint(constraint, userDescription);
        }
    }

    private void showStatistics(DbStructureVisitor visitor, ReadOperations read) {
        this.showNodeCounts(read, visitor);
        this.showRelCounts(read, visitor);
    }

    private void showNodeCounts(ReadOperations read, DbStructureVisitor visitor) {
        visitor.visitAllNodesCount(read.countsForNode(-1));
        for (Label label : this.glops.getAllLabels()) {
            int labelId = read.labelGetForName(label.name());
            visitor.visitNodeCount(labelId, label.name(), read.countsForNode(labelId));
        }
    }

    private void showRelCounts(ReadOperations read, DbStructureVisitor visitor) {
        this.noSide(read, visitor, WILDCARD_REL_TYPE, -1);
        for (Label label : this.glops.getAllLabels()) {
            int labelId = read.labelGetForName(label.name());
            this.leftSide(read, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
            this.rightSide(read, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
        }
        for (RelationshipType relType : this.glops.getAllRelationshipTypes()) {
            int relTypeId = read.relationshipTypeGetForName(relType.name());
            this.noSide(read, visitor, relType, relTypeId);
            for (Label label : this.glops.getAllLabels()) {
                int labelId = read.labelGetForName(label.name());
                this.leftSide(read, visitor, label, labelId, relType, relTypeId);
                this.rightSide(read, visitor, label, labelId, relType, relTypeId);
            }
        }
    }

    private void noSide(ReadOperations read, DbStructureVisitor visitor, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->() RETURN count(*)", this.colon(relType.name()));
        long amount = read.countsForRelationship(-1, relTypeId, -1);
        visitor.visitRelCount(-1, relTypeId, -1, userDescription, amount);
    }

    private void leftSide(ReadOperations read, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH (%s)-[%s]->() RETURN count(*)", this.colon(label.name()), this.colon(relType.name()));
        long amount = read.countsForRelationship(labelId, relTypeId, -1);
        visitor.visitRelCount(labelId, relTypeId, -1, userDescription, amount);
    }

    private void rightSide(ReadOperations read, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->(%s) RETURN count(*)", this.colon(relType.name()), this.colon(label.name()));
        long amount = read.countsForRelationship(-1, relTypeId, labelId);
        visitor.visitRelCount(-1, relTypeId, labelId, userDescription, amount);
    }

    private String colon(String name) {
        return name.length() == 0 ? name : ":" + name;
    }
}

