/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.impl.util.DebugUtil;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Neo4jJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private final String id;
    private ExecutorService executor;
    private ScheduledThreadPoolExecutor scheduledExecutor;

    public Neo4jJobScheduler() {
        this.id = this.getClass().getSimpleName();
    }

    public Neo4jJobScheduler(String id) {
        this.id = id;
    }

    @Override
    public void init() {
        this.executor = Executors.newCachedThreadPool(NamedThreadFactory.daemon("Neo4j " + this.id + DebugUtil.trackTest()));
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(2, NamedThreadFactory.daemon("Scheduled Neo4j " + this.id + DebugUtil.trackTest()));
    }

    @Override
    public Executor executor(final JobScheduler.Group group) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                Neo4jJobScheduler.this.schedule(group, command);
            }
        };
    }

    @Override
    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
        return new Handle(this.executor.submit(job));
    }

    @Override
    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group, runnable, 0L, period, timeUnit);
    }

    @Override
    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        return new Handle(this.scheduledExecutor.scheduleAtFixedRate(runnable, initialDelay, period, timeUnit));
    }

    @Override
    public void shutdown() {
        RuntimeException exception = null;
        try {
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                this.executor = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = new RuntimeException(e);
        }
        try {
            if (this.scheduledExecutor != null) {
                this.scheduledExecutor.shutdown();
                this.scheduledExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                this.scheduledExecutor = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = new RuntimeException(e);
        }
        if (exception != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }

    private class Handle
    implements JobScheduler.JobHandle {
        private final Future<?> job;

        public Handle(Future<?> job) {
            this.job = job;
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
            this.job.cancel(mayInterruptIfRunning);
        }
    }
}

