/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import org.neo4j.function.Function;

public class Converters {
    public static <T> Function<String, T> mandatory() {
        return new Function<String, T>(){

            public T apply(String key) {
                throw new IllegalArgumentException("Missing argument '" + key + "'");
            }
        };
    }

    public static <T> Function<String, T> optional() {
        return new Function<String, T>(){

            public T apply(String from) {
                return null;
            }
        };
    }

    public static <T> Function<String, T> withDefault(final T defaultValue) {
        return new Function<String, T>(){

            public T apply(String from) {
                return defaultValue;
            }
        };
    }

    public static Function<String, File> toFile() {
        return new Function<String, File>(){

            public File apply(String from) {
                return new File(from);
            }
        };
    }

    public static Function<String, File[]> toFiles(final String delimiter) {
        return new Function<String, File[]>(){

            public File[] apply(String from) {
                if (from == null) {
                    return new File[0];
                }
                String[] names = from.split(delimiter);
                File[] file = new File[names.length];
                for (int i = 0; i < names.length; ++i) {
                    file[i] = new File(names[i]);
                }
                return file;
            }
        };
    }

    public static Function<String, Character> toCharacter() {
        return new Function<String, Character>(){

            public Character apply(String value) {
                if (value.length() > 1) {
                    throw new IllegalArgumentException("Invalid delimiter '" + value + "', expected one character");
                }
                return Character.valueOf(value.charAt(0));
            }
        };
    }

    public static Function<String, Integer> toInt() {
        return new Function<String, Integer>(){

            public Integer apply(String from) {
                return new Integer(from);
            }
        };
    }
}

