/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import java.util.HashSet;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipDeleter;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;
import org.neo4j.kernel.impl.transaction.state.TransactionalRelationshipLocker;
import org.neo4j.kernel.impl.util.ArrayMap;

public class NeoStoreTransactionContext {
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter relationshipDeleter;
    private final NeoStoreTransactionContextSupplier supplier;
    private final PropertyTraverser propertyTraverser;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private final TransactionalRelationshipLocker locker;
    private final RelationshipGroupGetter relationshipGroupGetter;
    private final RecordAccessSet recordChangeSet;
    private final NeoStore neoStore;

    public NeoStoreTransactionContext(NeoStoreTransactionContextSupplier supplier, NeoStore neoStore) {
        this.supplier = supplier;
        this.neoStore = neoStore;
        this.recordChangeSet = new RecordChangeSet(neoStore);
        this.locker = new TransactionalRelationshipLocker();
        this.relationshipGroupGetter = new RelationshipGroupGetter(neoStore.getRelationshipGroupStore());
        this.propertyTraverser = new PropertyTraverser();
        this.propertyCreator = new PropertyCreator(neoStore.getPropertyStore(), this.propertyTraverser);
        this.propertyDeleter = new PropertyDeleter(neoStore.getPropertyStore(), this.propertyTraverser);
        this.relationshipCreator = new RelationshipCreator(this.locker, this.relationshipGroupGetter, neoStore.getDenseNodeThreshold());
        this.relationshipDeleter = new RelationshipDeleter(this.locker, this.relationshipGroupGetter, this.propertyDeleter);
    }

    public RecordAccessSet getRecordChangeSet() {
        return this.recordChangeSet;
    }

    public ArrayMap<Integer, DefinedProperty> relationshipDelete(long relId) {
        return this.relationshipDeleter.relDelete(relId, this.recordChangeSet);
    }

    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.relationshipCreator.relationshipCreate(id, typeId, startNodeId, endNodeId, this.recordChangeSet);
    }

    public ArrayMap<Integer, DefinedProperty> getAndDeletePropertyChain(NodeRecord nodeRecord) {
        return this.propertyDeleter.getAndDeletePropertyChain(nodeRecord, this.recordChangeSet.getPropertyRecords());
    }

    public <T extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<Long, T, Void> primitiveProxy, int propertyKey) {
        this.propertyDeleter.removeProperty(primitiveProxy, propertyKey, this.getPropertyRecords());
    }

    public <P extends PrimitiveRecord> void primitiveChangeProperty(RecordAccess.RecordProxy<Long, P, Void> primitive, int propertyKey, Object value) {
        this.propertyCreator.primitiveChangeProperty(primitive, propertyKey, value, this.getPropertyRecords());
    }

    public <P extends PrimitiveRecord> void primitiveAddProperty(RecordAccess.RecordProxy<Long, P, Void> primitive, int propertyKey, Object value) {
        this.propertyCreator.primitiveAddProperty(primitive, propertyKey, value, this.getPropertyRecords());
    }

    public void createPropertyKeyToken(String name, int id) {
        TokenCreator<PropertyKeyTokenRecord> creator = new TokenCreator<PropertyKeyTokenRecord>(this.neoStore.getPropertyKeyTokenStore());
        creator.createToken(name, id, this.getPropertyKeyTokenRecords());
    }

    public void createLabelToken(String name, int id) {
        TokenCreator<LabelTokenRecord> creator = new TokenCreator<LabelTokenRecord>(this.neoStore.getLabelTokenStore());
        creator.createToken(name, id, this.getLabelTokenRecords());
    }

    public void createRelationshipTypeToken(String name, int id) {
        TokenCreator<RelationshipTypeTokenRecord> creator = new TokenCreator<RelationshipTypeTokenRecord>(this.neoStore.getRelationshipTypeTokenStore());
        creator.createToken(name, id, this.getRelationshipTypeTokenRecords());
    }

    public void bind(Locks.Client locksClient) {
        this.locker.setLockClient(locksClient);
    }

    public void initialize() {
        this.recordChangeSet.close();
    }

    public void close() {
        this.recordChangeSet.close();
        this.locker.setLockClient(null);
        this.supplier.release(this);
    }

    public RecordAccess<Long, NodeRecord, Void> getNodeRecords() {
        return this.recordChangeSet.getNodeRecords();
    }

    public RecordAccess<Long, RelationshipRecord, Void> getRelRecords() {
        return this.recordChangeSet.getRelRecords();
    }

    public RecordAccess<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
        return this.recordChangeSet.getSchemaRuleChanges();
    }

    public RecordAccess<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.recordChangeSet.getPropertyRecords();
    }

    public RecordAccess<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.recordChangeSet.getRelGroupRecords();
    }

    public RecordAccess<Integer, PropertyKeyTokenRecord, Void> getPropertyKeyTokenRecords() {
        return this.recordChangeSet.getPropertyKeyTokenChanges();
    }

    public RecordAccess<Integer, LabelTokenRecord, Void> getLabelTokenRecords() {
        return this.recordChangeSet.getLabelTokenChanges();
    }

    public RecordAccess<Integer, RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenRecords() {
        return this.recordChangeSet.getRelationshipTypeTokenChanges();
    }

    public RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> getRelationshipGroup(NodeRecord node, int type) {
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        HashSet<Integer> allTypes = new HashSet<Integer>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> change = this.recordChangeSet.getRelGroupRecords().getOrLoad(groupId, type);
            RelationshipGroupRecord record = change.forReadingData();
            record.setPrev(previousGroupId);
            allTypes.add(record.getType());
            if (record.getType() == type) {
                return change;
            }
            previousGroupId = groupId;
            groupId = record.getNext();
        }
        return null;
    }

    public boolean hasChanges() {
        return this.recordChangeSet.hasChanges();
    }
}

