/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class IndexTransactionApplier
extends NeoCommandHandler.Adapter {
    private static final Comparator<NodeLabelUpdate> nodeLabelUpdateComparator = new Comparator<NodeLabelUpdate>(){

        @Override
        public int compare(NodeLabelUpdate o1, NodeLabelUpdate o2) {
            return Long.compare(o1.getNodeId(), o2.getNodeId());
        }
    };
    private final ValidatedIndexUpdates indexUpdates;
    private List<NodeLabelUpdate> labelUpdates;
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;

    public IndexTransactionApplier(IndexingService indexingService, ValidatedIndexUpdates indexUpdates, LabelScanStore labelScanStore) {
        this.indexingService = indexingService;
        this.indexUpdates = indexUpdates;
        this.labelScanStore = labelScanStore;
    }

    @Override
    public void apply() {
        try {
            if (this.labelUpdates != null) {
                this.updateLabelScanStore();
            }
            if (this.indexUpdates.hasChanges()) {
                this.updateIndexes();
            }
        }
        catch (IOException | IndexCapacityExceededException | IndexEntryConflictException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexes() throws IOException, IndexCapacityExceededException, IndexEntryConflictException {
        IndexingService indexingService = this.indexingService;
        synchronized (indexingService) {
            this.indexUpdates.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabelScanStore() throws IOException, IndexCapacityExceededException {
        Collections.sort(this.labelUpdates, nodeLabelUpdateComparator);
        LabelScanStore labelScanStore = this.labelScanStore;
        synchronized (labelScanStore) {
            try (LabelScanWriter writer = this.labelScanStore.newWriter();){
                for (NodeLabelUpdate update : this.labelUpdates) {
                    writer.write(update);
                }
            }
        }
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        NodeRecord before = command.getBefore();
        NodeRecord after = command.getAfter();
        NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(before);
        NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(after);
        if (!labelFieldBefore.isInlined() || !labelFieldAfter.isInlined() || before.getLabelField() != after.getLabelField()) {
            long[] labelsBefore = labelFieldBefore.getIfLoaded();
            long[] labelsAfter = labelFieldAfter.getIfLoaded();
            if (labelsBefore != null && labelsAfter != null) {
                this.addLabelUpdate(NodeLabelUpdate.labelChanges(command.getKey(), labelsBefore, labelsAfter));
            }
        }
        return false;
    }

    private void addLabelUpdate(NodeLabelUpdate labelChanges) {
        if (this.labelUpdates == null) {
            this.labelUpdates = new ArrayList<NodeLabelUpdate>();
        }
        this.labelUpdates.add(labelChanges);
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        if (command.getSchemaRule() instanceof IndexRule) {
            switch (command.getMode()) {
                case UPDATE: {
                    if (!((IndexRule)command.getSchemaRule()).isConstraintIndex()) break;
                    try {
                        this.indexingService.activateIndex(command.getSchemaRule().getId());
                        break;
                    }
                    catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                        throw new IllegalStateException("Unable to enable constraint, backing index is not online.", e);
                    }
                }
                case CREATE: {
                    this.indexingService.createIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                case DELETE: {
                    this.indexingService.dropIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        return false;
    }
}

