/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StoreMigrationTool {
    public static void main(String[] args) throws IOException {
        String legacyStoreDirectory = args[0];
        FormattedLogProvider userLogProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out, (boolean)false, (boolean)true);
        new StoreMigrationTool().run((FileSystemAbstraction)new DefaultFileSystemAbstraction(), new File(legacyStoreDirectory), new Config(), (LogProvider)userLogProvider, StoreUpgrader.NO_MONITOR);
    }

    public void run(FileSystemAbstraction fs, File legacyStoreDirectory, Config config, LogProvider userLogProvider, StoreUpgrader.Monitor monitor) throws IOException {
        ConfigMapUpgradeConfiguration upgradeConfiguration = new ConfigMapUpgradeConfiguration(config);
        StoreUpgrader migrationProcess = new StoreUpgrader(upgradeConfiguration, fs, monitor, userLogProvider);
        LifeSupport life = new LifeSupport();
        KernelExtensions kernelExtensions = life.add(new KernelExtensions(GraphDatabaseDependencies.newDependencies().kernelExtensions(), this.kernelExtensionDependencyResolver(fs, config), UnsatisfiedDependencyStrategies.ignore()));
        JobScheduler jobScheduler = life.add(new Neo4jJobScheduler());
        StoreLogService logService = new StoreLogService(userLogProvider, fs, legacyStoreDirectory, jobScheduler);
        config = StoreFactory.configForStoreDir(config, legacyStoreDirectory);
        life.start();
        SchemaIndexProvider schemaIndexProvider = kernelExtensions.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        Log log = userLogProvider.getLog(StoreMigrationTool.class);
        try {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(fs));
            migrationProcess.addParticipant(new StoreMigrator(new VisibleMigrationProgressMonitor(logService.getInternalLog(StoreMigrationTool.class)), fs, upgradableDatabase, config, logService));
            migrationProcess.addParticipant(schemaIndexProvider.storeMigrationParticipant(fs, upgradableDatabase));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache(fs, config);){
            long startTime = System.currentTimeMillis();
            migrationProcess.migrateIfNeeded(legacyStoreDirectory, schemaIndexProvider, pageCache);
            long duration = System.currentTimeMillis() - startTime;
            log.info(String.format("Migration completed in %d s%n", duration / 1000L));
        }
        catch (IOException e) {
            throw new StoreUpgrader.UnableToUpgradeException("Failure during upgrade", e);
        }
        finally {
            life.shutdown();
        }
    }

    private DependencyResolver kernelExtensionDependencyResolver(final FileSystemAbstraction fileSystem, final Config config) {
        return new DependencyResolver.Adapter(){

            @Override
            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (type.isInstance(fileSystem)) {
                    return type.cast(fileSystem);
                }
                if (type.isInstance(config)) {
                    return type.cast(config);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }
}

