/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFileType;

public enum StoreFile {
    NODE_STORE("NodeStore", ".nodestore.db", "v0.A.0"),
    NODE_LABEL_STORE("ArrayPropertyStore", ".nodestore.db.labels", "v0.A.1"),
    PROPERTY_STORE("PropertyStore", ".propertystore.db", "v0.A.0"),
    PROPERTY_ARRAY_STORE("ArrayPropertyStore", ".propertystore.db.arrays", "v0.A.0"),
    PROPERTY_STRING_STORE("StringPropertyStore", ".propertystore.db.strings", "v0.A.0"),
    PROPERTY_KEY_TOKEN_STORE("PropertyIndexStore", ".propertystore.db.index", "v0.A.0"),
    PROPERTY_KEY_TOKEN_NAMES_STORE("StringPropertyStore", ".propertystore.db.index.keys", "v0.A.0"),
    RELATIONSHIP_STORE("RelationshipStore", ".relationshipstore.db", "v0.A.0"),
    RELATIONSHIP_GROUP_STORE("RelationshipGroupStore", ".relationshipgroupstore.db", "v0.A.3"),
    RELATIONSHIP_TYPE_TOKEN_STORE("RelationshipTypeStore", ".relationshiptypestore.db", "v0.A.0"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("StringPropertyStore", ".relationshiptypestore.db.names", "v0.A.0"),
    LABEL_TOKEN_STORE("LabelTokenStore", ".labeltokenstore.db", "v0.A.1"),
    LABEL_TOKEN_NAMES_STORE("StringPropertyStore", ".labeltokenstore.db.names", "v0.A.1"),
    SCHEMA_STORE("SchemaStore", ".schemastore.db", "v0.A.1"),
    COUNTS_STORE_LEFT("CountsStore", ".counts.db.a", "v0.A.5"){

        @Override
        boolean isOptional() {
            return true;
        }
    }
    ,
    COUNTS_STORE_RIGHT("CountsStore", ".counts.db.b", "v0.A.5"){

        @Override
        boolean isOptional() {
            return true;
        }
    }
    ,
    NEO_STORE("NeoStore", "", "v0.A.0");

    private final String typeDescriptor;
    private final String storeFileNamePart;
    private final String sinceVersion;

    private StoreFile(String typeDescriptor, String storeFileNamePart, String sinceVersion) {
        this.typeDescriptor = typeDescriptor;
        this.storeFileNamePart = storeFileNamePart;
        this.sinceVersion = sinceVersion;
    }

    public String forVersion(String version) {
        return this.typeDescriptor + " " + version;
    }

    public String typeDescriptor() {
        return this.typeDescriptor;
    }

    public String fileName(StoreFileType type) {
        return type.augment("neostore" + this.storeFileNamePart);
    }

    public String storeFileName() {
        return this.fileName(StoreFileType.STORE);
    }

    public String idFileName() {
        return this.fileName(StoreFileType.ID);
    }

    public String storeFileNamePart() {
        return this.storeFileNamePart;
    }

    public static Iterable<StoreFile> legacyStoreFilesForVersion(final String version) {
        Predicate<StoreFile> predicate = new Predicate<StoreFile>(){

            public boolean test(StoreFile item) {
                return version.compareTo(item.sinceVersion) >= 0;
            }
        };
        Iterable<StoreFile> storeFiles = StoreFile.currentStoreFiles();
        Iterable<StoreFile> filter = Iterables.filter(predicate, storeFiles);
        return filter;
    }

    public static Iterable<StoreFile> currentStoreFiles() {
        return Iterables.iterable(StoreFile.values());
    }

    public static void fileOperation(FileOperation operation, FileSystemAbstraction fs, File fromDirectory, File toDirectory, Iterable<StoreFile> files, boolean allowSkipNonExistentFiles, boolean allowOverwriteTarget, StoreFileType ... types) throws IOException {
        for (StoreFile storeFile : files) {
            for (StoreFileType type : types) {
                String fileName = storeFile.fileName(type);
                operation.perform(fs, fileName, fromDirectory, allowSkipNonExistentFiles, toDirectory, allowOverwriteTarget);
            }
        }
    }

    public static void ensureStoreVersion(FileSystemAbstraction fs, File storeDir, Iterable<StoreFile> files) throws IOException {
        StoreFile.ensureStoreVersion(fs, storeDir, files, "v0.A.5");
    }

    public static void ensureStoreVersion(FileSystemAbstraction fs, File storeDir, Iterable<StoreFile> files, String version) throws IOException {
        for (StoreFile file : files) {
            StoreFile.setStoreVersionTrailer(fs, new File(storeDir, file.storeFileName()), file.isOptional(), CommonAbstractStore.buildTypeDescriptorAndVersion(file.typeDescriptor(), version));
        }
        NeoStore.setRecord(fs, new File(storeDir, "neostore"), NeoStore.Position.STORE_VERSION, NeoStore.versionStringToLong(version));
    }

    boolean isOptional() {
        return false;
    }

    private static void setStoreVersionTrailer(FileSystemAbstraction fs, File targetStoreFileName, boolean optional, String versionTrailer) throws IOException {
        byte[] trailer = UTF8.encode(versionTrailer);
        long fileSize = 0L;
        if (!fs.fileExists(targetStoreFileName)) {
            if (optional) {
                return;
            }
            throw new IllegalStateException("Required file missing: " + targetStoreFileName);
        }
        try (StoreChannel fileChannel = fs.open(targetStoreFileName, "rw");){
            fileSize = fileChannel.size();
            fileChannel.position(fileChannel.size() - (long)trailer.length);
            fileChannel.write(ByteBuffer.wrap(trailer));
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.withMessage(e, e.getMessage() + " | " + "size:" + fileSize + ", trailer:" + trailer.length + " for " + targetStoreFileName);
        }
    }
}

