/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.standard;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.format.Store;
import org.neo4j.kernel.impl.store.standard.IdGeneratorRebuilder;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.store.standard.StoreOpenCloseCycle;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.LogProvider;

public class StandardStore<RECORD, CURSOR extends Store.RecordCursor>
extends LifecycleAdapter
implements Store<RECORD, CURSOR> {
    private final StoreFormat<RECORD, CURSOR> storeFormat;
    private final StoreFormat.RecordFormat<RECORD> recordFormat;
    private final StoreIdGenerator idGenerator;
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final File dbFileName;
    private final StoreOpenCloseCycle openCloseLogic;
    private final IdGeneratorRebuilder.Factory idGeneratorRebuilding;
    private StoreToolkit toolkit;
    private PagedFile file;
    private StoreChannel channel;

    public StandardStore(StoreFormat<RECORD, CURSOR> format, File dbFileName, StoreIdGenerator idGenerator, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider) {
        this(format, dbFileName, idGenerator, pageCache, fs, new IdGeneratorRebuilder.FindHighestInUseRebuilderFactory(), new StoreOpenCloseCycle(logProvider.getLog(StandardStore.class), dbFileName, format, fs));
    }

    public StandardStore(StoreFormat<RECORD, CURSOR> format, File dbFileName, StoreIdGenerator idGenerator, PageCache pageCache, FileSystemAbstraction fs, IdGeneratorRebuilder.Factory idGeneratorRebuilding, StoreOpenCloseCycle openCloseCycle) {
        this.storeFormat = format;
        this.recordFormat = format.recordFormat();
        this.dbFileName = dbFileName;
        this.idGenerator = idGenerator;
        this.pageCache = pageCache;
        this.fs = fs;
        this.idGeneratorRebuilding = idGeneratorRebuilding;
        this.openCloseLogic = openCloseCycle;
    }

    @Override
    public CURSOR cursor(int flags) {
        return this.storeFormat.createCursor(this.file, this.toolkit, flags);
    }

    @Override
    public RECORD read(long id) throws IOException {
        long pageId = this.toolkit.pageId(id);
        int offset = this.toolkit.recordOffset(id);
        Throwable throwable = null;
        try (PageCursor cursor = this.file.io(pageId, 5);){
            if (cursor.next()) {
                RECORD record = this.recordFormat.newRecord(id);
                do {
                    this.recordFormat.deserialize(cursor, offset, id, record);
                } while (cursor.shouldRetry());
                RECORD RECORD = record;
                return RECORD;
            }
            try {
                throw new InvalidRecordException(this.recordFormat.recordName() + "[" + id + "] not in use");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public void write(RECORD record) throws IOException {
        long id = this.recordFormat.id(record);
        long pageId = this.toolkit.pageId(id);
        int offset = this.toolkit.recordOffset(id);
        try (PageCursor cursor = this.file.io(pageId, 2);){
            if (cursor.next()) {
                do {
                    this.recordFormat.serialize(cursor, offset, record);
                } while (cursor.shouldRetry());
            }
        }
    }

    @Override
    public long allocate() {
        return this.idGenerator.allocate();
    }

    @Override
    public void free(long id) {
        this.idGenerator.free(id);
    }

    @Override
    public void start() throws Throwable {
        if (!this.fs.fileExists(this.dbFileName)) {
            this.createNewStore();
        } else {
            this.openExistingStore();
        }
    }

    @Override
    public void stop() throws Throwable {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
        if (this.channel != null) {
            this.openCloseLogic.closeStore(this.channel, this.idGenerator.highestIdInUse());
            this.channel.close();
            this.channel = null;
        }
    }

    private void openExistingStore() throws IOException {
        this.channel = this.fs.open(this.dbFileName, "rw");
        this.initializeToolkit();
        boolean idGeneratorNeedsRebuilding = this.openCloseLogic.openStore(this.channel);
        this.file = this.pageCache.map(this.dbFileName, this.toolkit.pageSize());
        if (idGeneratorNeedsRebuilding) {
            IdGeneratorRebuilder rebuilder = this.idGeneratorRebuilding.newIdGeneratorRebuilder(this, this.toolkit, this.idGenerator);
            rebuilder.rebuildIdGenerator();
        }
    }

    private void createNewStore() throws IOException {
        this.fs.mkdirs(this.dbFileName.getParentFile());
        this.fs.create(this.dbFileName);
        this.channel = this.fs.open(this.dbFileName, "rw");
        this.storeFormat.createStore(this.channel);
        this.initializeToolkit();
        this.file = this.pageCache.map(this.dbFileName, this.toolkit.pageSize());
        for (int headerSize = this.storeFormat.headerSize(); headerSize > 0; headerSize -= this.toolkit.recordSize()) {
            this.allocate();
        }
    }

    private void initializeToolkit() throws IOException {
        int recordSize = this.storeFormat.recordSize(this.channel);
        int headerSize = this.storeFormat.headerSize();
        int firstRecordId = headerSize == 0 ? 0 : (int)Math.ceil((double)headerSize / (1.0 * (double)recordSize));
        int pageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % recordSize;
        this.toolkit = new StoreToolkit(recordSize, pageSize, firstRecordId, this.channel, this.idGenerator);
    }
}

