/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.util.Random;
import org.neo4j.kernel.impl.store.NeoStore;

public final class StoreId
implements Externalizable {
    public static final long CURRENT_STORE_VERSION = NeoStore.versionStringToLong("v0.A.5");
    public static final StoreId DEFAULT = new StoreId(-1L, -1L, -1L, -1L);
    private static final Random r = new SecureRandom();
    private long creationTime;
    private long randomId;
    private long storeVersion;
    private long upgradeTime;
    private long upgradeId;

    public StoreId() {
        long currentTimeMillis = System.currentTimeMillis();
        long randomLong = r.nextLong();
        this.creationTime = currentTimeMillis;
        this.randomId = randomLong;
        this.storeVersion = CURRENT_STORE_VERSION;
        this.upgradeTime = currentTimeMillis;
        this.upgradeId = randomLong;
    }

    public StoreId(long creationTime, long randomId, long upgradeTime, long upgradeId) {
        this(creationTime, randomId, CURRENT_STORE_VERSION, upgradeTime, upgradeId);
    }

    public StoreId(long creationTime, long randomId, long storeVersion, long upgradeTime, long upgradeId) {
        this.creationTime = creationTime;
        this.randomId = randomId;
        this.storeVersion = storeVersion;
        this.upgradeTime = upgradeTime;
        this.upgradeId = upgradeId;
    }

    public static StoreId from(ObjectInput in) throws IOException, ClassNotFoundException {
        StoreId storeId = new StoreId();
        storeId.readExternal(in);
        return storeId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public long getUpgradeTime() {
        return this.upgradeTime;
    }

    public long getUpgradeId() {
        return this.upgradeId;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.randomId);
        out.writeLong(this.storeVersion);
        out.writeLong(this.upgradeTime);
        out.writeLong(this.upgradeId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.creationTime = in.readLong();
        this.randomId = in.readLong();
        this.storeVersion = in.readLong();
        this.upgradeTime = in.readLong();
        this.upgradeId = in.readLong();
    }

    public boolean equalsByUpgradeId(StoreId other) {
        return StoreId.equal(this.upgradeTime, other.upgradeTime) && StoreId.equal(this.upgradeId, other.upgradeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreId other = (StoreId)o;
        return StoreId.equal(this.creationTime, other.creationTime) && StoreId.equal(this.randomId, other.randomId);
    }

    public int hashCode() {
        return 31 * (int)(this.creationTime ^ this.creationTime >>> 32) + (int)(this.randomId ^ this.randomId >>> 32);
    }

    public String toString() {
        return "StoreId{creationTime=" + this.creationTime + ", randomId=" + this.randomId + ", storeVersion=" + this.storeVersion + ", upgradeTime=" + this.upgradeTime + ", upgradeId=" + this.upgradeId + '}';
    }

    private static boolean equal(long first, long second) {
        return first == second || first == -1L || second == -1L;
    }
}

