/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.transaction.log.LogRecoveryCheck;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.logging.LogProvider;

public class StoreRecoverer {
    private final FileSystemAbstraction fs;

    public StoreRecoverer() {
        this((FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public StoreRecoverer(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    public boolean recoveryNeededAt(File dataDir) throws IOException {
        long logVersion = this.fs.fileExists(new File(dataDir, "neostore")) ? new NeoStoreUtil(dataDir, this.fs).getLogVersion() : 0L;
        return this.recoveryNeededAt(dataDir, logVersion);
    }

    public boolean recoveryNeededAt(File dataDir, long currentLogVersion) throws IOException {
        File neoStorePath = new File(dataDir, "neostore");
        if (!this.fs.fileExists(neoStorePath)) {
            return false;
        }
        PhysicalLogFiles logFiles = new PhysicalLogFiles(dataDir, this.fs);
        File log = logFiles.getLogFileForVersion(currentLogVersion);
        if (!this.fs.fileExists(log)) {
            return false;
        }
        try (StoreChannel logChannel = this.fs.open(log, "r");){
            boolean bl = LogRecoveryCheck.recoveryRequired(logChannel);
            return bl;
        }
    }

    public void recover(File dataDir, Map<String, String> params, LogProvider userLogProvider) {
        new EmbeddedGraphDatabase(dataDir.getAbsolutePath(), params, GraphDatabaseDependencies.newDependencies().userLogProvider(userLogProvider)).shutdown();
    }
}

