/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.neo4j.function.Consumer;
import org.neo4j.function.Consumers;
import org.neo4j.function.Supplier;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.logging.AbstractLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class StoreLogService
extends AbstractLogService
implements Lifecycle {
    public static final String INTERNAL_LOG_NAME = "messages.log";
    private final Closeable closeable;
    private final SimpleLogService logService;

    public StoreLogService(LogProvider userLogProvider, FileSystemAbstraction fileSystem, File storeDirectory, JobScheduler jobScheduler) throws IOException {
        this(userLogProvider, fileSystem, storeDirectory, 0L, 0, 0, jobScheduler, (Consumer<LogProvider>)Consumers.noop());
    }

    public StoreLogService(LogProvider userLogProvider, FileSystemAbstraction fileSystem, File storeDirectory, long internalLogRotationThreshold, int internalLogRotationDelay, int maxInternalLogArchives, JobScheduler jobScheduler, Consumer<LogProvider> rotationListener) throws IOException {
        this(userLogProvider, fileSystem, storeDirectory, internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, jobScheduler.executor(JobScheduler.Group.internalLogRotation), rotationListener);
    }

    public StoreLogService(LogProvider userLogProvider, FileSystemAbstraction fileSystem, File storeDirectory, long internalLogRotationThreshold, int internalLogRotationDelay, int maxInternalLogArchives, Executor rotationExecutor, final Consumer<LogProvider> rotationListener) throws IOException {
        FormattedLogProvider internalLogProvider;
        File logFile = new File(storeDirectory, INTERNAL_LOG_NAME);
        if (internalLogRotationThreshold == 0L) {
            OutputStream outputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)logFile, (boolean)true);
            internalLogProvider = FormattedLogProvider.toOutputStream((OutputStream)outputStream);
            rotationListener.accept((Object)internalLogProvider);
            this.closeable = outputStream;
        } else {
            RotatingFileOutputStreamSupplier rotatingSupplier = new RotatingFileOutputStreamSupplier(fileSystem, logFile, internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, rotationExecutor, new RotatingFileOutputStreamSupplier.RotationListener(){

                public void outputFileCreated(OutputStream newStream, OutputStream oldStream) {
                    FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)newStream);
                    logProvider.getLog(StoreLogService.class).info("Opened new internal log file");
                    rotationListener.accept((Object)logProvider);
                    logProvider.getLog(StoreLogService.class).info("Rotated internal log file");
                }
            });
            internalLogProvider = FormattedLogProvider.toOutputStream((Supplier)rotatingSupplier);
            this.closeable = rotatingSupplier;
        }
        this.logService = new SimpleLogService(userLogProvider, (LogProvider)internalLogProvider);
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
    }

    @Override
    public void stop() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        this.closeable.close();
    }

    @Override
    public LogProvider getUserLogProvider() {
        return this.logService.getUserLogProvider();
    }

    @Override
    public LogProvider getInternalLogProvider() {
        return this.logService.getInternalLogProvider();
    }
}

