/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.GraphProperties;

public class GraphPropertiesProxy
implements GraphProperties {
    private final GraphPropertiesActions actions;

    public GraphPropertiesProxy(GraphPropertiesActions actions) {
        this.actions = actions;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabaseService();
    }

    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = statement.readOperations().graphGetProperty(propertyKeyId).isDefined();
            return bl;
        }
    }

    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.readOperations().graphGetProperty(propertyKeyId).value();
            return object;
        }
        catch (PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            Object object = statement.readOperations().graphGetProperty(propertyKeyId).value(defaultValue);
            return object;
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            try {
                statement.dataWriteOperations().graphSetProperty(Property.property(propertyKeyId, value));
            }
            catch (IllegalArgumentException e) {
                this.actions.failTransaction();
                throw e;
            }
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().graphRemoveProperty(propertyKeyId).value(null);
            return object;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.actions.statement();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().graphGetAllProperties();
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.", e);
        }
    }

    public boolean equals(Object o) {
        return o instanceof GraphPropertiesProxy && this.actions.getGraphDatabaseService() == ((GraphPropertiesProxy)o).actions.getGraphDatabaseService();
    }

    public int hashCode() {
        return this.actions.getGraphDatabaseService().hashCode();
    }

    public static interface GraphPropertiesActions {
        public Statement statement();

        public GraphDatabaseService getGraphDatabaseService();

        public void failTransaction();

        public void assertInUnterminatedTransaction();
    }
}

