/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.function.Supplier;
import org.neo4j.function.primitive.PrimitiveIntPredicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.StoreRelationshipIterable;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class DiskLayer
implements StoreReadLayer {
    private static final Function<UniquenessConstraintRule, UniquenessConstraint> UNIQUENESS_CONSTRAINT_TO_RULE = new Function<UniquenessConstraintRule, UniquenessConstraint>(){

        public UniquenessConstraint apply(UniquenessConstraintRule rule) {
            return new UniquenessConstraint(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTokenHolder;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final RelationshipStore relationshipStore;
    private final SchemaStorage schemaStorage;
    private final CountsAccessor counts;
    private final PropertyLoader propertyLoader;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        public boolean test(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        public boolean test(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public DiskLayer(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTokenHolder, SchemaStorage schemaStorage, Supplier<NeoStore> neoStoreSupplier, IndexingService indexService) {
        this.relationshipTokenHolder = relationshipTokenHolder;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStore = (NeoStore)neoStoreSupplier.get();
        this.nodeStore = this.neoStore.getNodeStore();
        this.relationshipStore = this.neoStore.getRelationshipStore();
        this.relationshipGroupStore = this.neoStore.getRelationshipGroupStore();
        this.counts = this.neoStore.getCounts();
        this.propertyLoader = new PropertyLoader(this.neoStore);
    }

    @Override
    public int labelGetOrCreateForName(String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public int labelGetForName(String label) {
        return this.labelTokenHolder.getIdByName(label);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, int labelId) throws EntityNotFoundException {
        try {
            return PrimitiveIntCollections.indexOf((PrimitiveIntIterator)this.nodeGetLabels(nodeId), (int)labelId) != -1;
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(long nodeId) throws EntityNotFoundException {
        NodeRecord record = this.nodeStore.loadRecord(nodeId, null);
        if (record == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        final long[] labels = NodeLabelsField.parseLabelsField(record).get(this.nodeStore);
        return new PrimitiveIntIterator(){
            private int cursor;

            public boolean hasNext() {
                return this.cursor < labels.length;
            }

            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IoPrimitiveUtils.safeCastLongToInt(labels[this.cursor++]);
            }
        };
    }

    @Override
    public RelationshipIterator nodeListRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        return StoreRelationshipIterable.iterator(this.neoStore, nodeId, PrimitiveIntCollections.alwaysTrue(), direction);
    }

    @Override
    public RelationshipIterator nodeListRelationships(long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        return StoreRelationshipIterable.iterator(this.neoStore, nodeId, (PrimitiveIntPredicate)PrimitiveIntCollections.asSet((int[])relTypes), direction);
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        NodeRecord node = this.nodeStore.loadRecord(nodeId, null);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        if (node.isDense()) {
            long groupId = node.getNextRel();
            long count = 0L;
            while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                RelationshipGroupRecord group = this.relationshipGroupStore.getRecord(groupId);
                count += this.nodeDegreeByDirection(nodeId, group, direction);
                groupId = group.getNext();
            }
            return (int)count;
        }
        return PrimitiveLongCollections.count((PrimitiveLongIterator)this.nodeListRelationships(nodeId, direction));
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        NodeRecord node = this.nodeStore.loadRecord(nodeId, null);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        if (node.isDense()) {
            long groupId = node.getNextRel();
            while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                RelationshipGroupRecord group = this.relationshipGroupStore.getRecord(groupId);
                if (group.getType() == relType) {
                    return (int)this.nodeDegreeByDirection(nodeId, group, direction);
                }
                groupId = group.getNext();
            }
            return 0;
        }
        return PrimitiveLongCollections.count((PrimitiveLongIterator)this.nodeListRelationships(nodeId, direction, new int[]{relType}));
    }

    private long nodeDegreeByDirection(long nodeId, RelationshipGroupRecord group, Direction direction) {
        long loopCount = this.countByFirstPrevPointer(nodeId, group.getFirstLoop());
        switch (direction) {
            case OUTGOING: {
                return this.countByFirstPrevPointer(nodeId, group.getFirstOut()) + loopCount;
            }
            case INCOMING: {
                return this.countByFirstPrevPointer(nodeId, group.getFirstIn()) + loopCount;
            }
            case BOTH: {
                return this.countByFirstPrevPointer(nodeId, group.getFirstOut()) + this.countByFirstPrevPointer(nodeId, group.getFirstIn()) + loopCount;
            }
        }
        throw new IllegalArgumentException(direction.name());
    }

    @Override
    public boolean nodeVisitDegrees(final long nodeId, final DegreeVisitor visitor) {
        NodeRecord node = this.nodeStore.loadRecord(nodeId, null);
        if (node == null) {
            return true;
        }
        if (node.isDense()) {
            long groupId = node.getNextRel();
            while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                RelationshipGroupRecord group = this.relationshipGroupStore.getRecord(groupId);
                long outCount = this.countByFirstPrevPointer(nodeId, group.getFirstOut());
                long inCount = this.countByFirstPrevPointer(nodeId, group.getFirstIn());
                long loopCount = this.countByFirstPrevPointer(nodeId, group.getFirstLoop());
                visitor.visitDegree(group.getType(), (int)(outCount + loopCount), (int)(inCount + loopCount));
                groupId = group.getNext();
            }
        } else {
            final PrimitiveIntObjectMap degrees = Primitive.intObjectMap((int)5);
            RelationshipVisitor<RuntimeException> typeVisitor = new RelationshipVisitor<RuntimeException>(){

                @Override
                public void visit(long relId, int type, long startNode, long endNode) throws RuntimeException {
                    int[] byType = (int[])degrees.get(type);
                    if (byType == null) {
                        byType = new int[3];
                        degrees.put(type, (Object)byType);
                    }
                    int n = DiskLayer.this.directionOf(nodeId, relId, startNode, endNode).ordinal();
                    byType[n] = byType[n] + 1;
                }
            };
            try {
                RelationshipIterator relationships = this.nodeListRelationships(nodeId, Direction.BOTH);
                while (relationships.hasNext()) {
                    relationships.relationshipVisit(relationships.next(), typeVisitor);
                }
                degrees.visitEntries((PrimitiveIntObjectVisitor)new PrimitiveIntObjectVisitor<int[], RuntimeException>(){

                    public boolean visited(int type, int[] degrees) throws RuntimeException {
                        visitor.visitDegree(type, degrees[0] + degrees[2], degrees[1] + degrees[2]);
                        return false;
                    }
                });
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        return false;
    }

    private Direction directionOf(long nodeId, long relationshipId, long startNode, long endNode) {
        if (startNode == nodeId) {
            return endNode == nodeId ? Direction.BOTH : Direction.OUTGOING;
        }
        if (endNode == nodeId) {
            return Direction.INCOMING;
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of relationship " + relationshipId + " with startNode:" + startNode + " and endNode:" + endNode);
    }

    private long countByFirstPrevPointer(long nodeId, long relationshipId) {
        if (relationshipId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0L;
        }
        RelationshipRecord record = this.relationshipStore.getRecord(relationshipId);
        if (record.getFirstNode() == nodeId) {
            return record.getFirstPrevRel();
        }
        if (record.getSecondNode() == nodeId) {
            return record.getSecondPrevRel();
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of " + record);
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        final NodeRecord node = this.nodeStore.loadRecord(nodeId, null);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        if (node.isDense()) {
            return new PrimitiveIntCollections.PrimitiveIntBaseIterator(){
                private long groupId;
                {
                    this.groupId = node.getNextRel();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected boolean fetchNext() {
                    if (this.groupId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                        return false;
                    }
                    RelationshipGroupRecord group = DiskLayer.this.relationshipGroupStore.getRecord(this.groupId);
                    try {
                        boolean bl = this.next(group.getType());
                        return bl;
                    }
                    finally {
                        this.groupId = group.getNext();
                    }
                }
            };
        }
        final PrimitiveIntSet types = Primitive.intSet((int)5);
        RelationshipVisitor<RuntimeException> visitor = new RelationshipVisitor<RuntimeException>(){

            @Override
            public void visit(long relId, int type, long startNode, long endNode) throws RuntimeException {
                types.add(type);
            }
        };
        RelationshipIterator relationships = this.nodeListRelationships(nodeId, Direction.BOTH);
        while (relationships.hasNext()) {
            relationships.relationshipVisit(relationships.next(), visitor);
        }
        return types.iterator();
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return state.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetFromIndexScan(KernelStatement state, IndexDescriptor index) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKey) {
        return DiskLayer.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            public boolean test(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            public boolean test(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAllSchemaRules());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            public IndexDescriptor apply(SchemaRule from) {
                return DiskLayer.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        return this.nodeStore.inUse(nodeId);
    }

    @Override
    public boolean relationshipExists(long relationshipId) {
        return this.relationshipStore.inUse(relationshipId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public IndexRule indexRule(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(this.indexId(descriptor)).getState();
    }

    @Override
    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.indexUniqueValuesPercentage(this.indexId(descriptor));
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(this.indexId(descriptor)).getPopulationFailure().asString();
    }

    private long indexId(IndexDescriptor descriptor) {
        return this.schemaStorage.indexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(int labelId, final int propertyKeyId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            public boolean test(UniquenessConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, Predicates.alwaysTrue());
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, SchemaRule.Kind.UNIQUENESS_CONSTRAINT, Predicates.alwaysTrue());
    }

    @Override
    public PrimitiveLongResourceIterator nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public int propertyKeyGetForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getIdByName(propertyKey);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, e);
        }
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(long relationshipId) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        IteratingPropertyReceiver properties = this.propertyLoader.relLoadProperties(relationshipId, new IteratingPropertyReceiver());
        Property property = this.property(properties, propertyKeyId);
        return property != null ? property : Property.noRelationshipProperty(relationshipId, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(long nodeId) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property nodeGetProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        IteratingPropertyReceiver properties = this.propertyLoader.nodeLoadProperties(nodeId, new IteratingPropertyReceiver());
        Property property = this.property(properties, propertyKeyId);
        return property != null ? property : Property.noNodeProperty(nodeId, propertyKeyId);
    }

    private Property property(IteratingPropertyReceiver properties, int propertyKeyId) {
        while (properties.hasNext()) {
            DefinedProperty property = (DefinedProperty)properties.next();
            if (property.propertyKeyId() != propertyKeyId) continue;
            return property;
        }
        return null;
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(long nodeId) throws EntityNotFoundException {
        return this.propertyLoader.nodeLoadProperties(nodeId, new IteratingPropertyReceiver());
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(long relationshipId) throws EntityNotFoundException {
        return this.propertyLoader.relLoadProperties(relationshipId, new IteratingPropertyReceiver());
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property graphGetProperty(int propertyKeyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties() {
        return this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver());
    }

    public PrimitiveLongResourceIterator nodeGetUniqueFromIndexLookup(KernelStatement state, long indexId, Object value) throws IndexNotFoundKernelException {
        IndexReader reader = state.getFreshIndexReader(indexId);
        return IteratorUtil.resourceIterator(reader.lookup(value), (Resource)reader);
    }

    public PrimitiveLongResourceIterator nodesGetFromIndexLookup(KernelStatement state, long index, Object value) throws IndexNotFoundKernelException {
        IndexReader reader = state.getIndexReader(index);
        return IteratorUtil.resourceIterator(reader.lookup(value), (Resource)reader);
    }

    public PrimitiveLongResourceIterator nodesGetFromIndexScan(KernelStatement state, long index) throws IndexNotFoundKernelException {
        IndexReader reader = state.getIndexReader(index);
        return IteratorUtil.resourceIterator(reader.scan(), (Resource)reader);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.propertyKeyTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getIdByName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((Token)this.relationshipTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getOrCreateId(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipRecord record;
        try {
            record = this.relationshipStore.getRecord(relationshipId);
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        relationshipVisitor.visit(relationshipId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public long highestNodeIdInUse() {
        return this.nodeStore.getHighestPossibleIdInUse();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return new PrimitiveLongCollections.PrimitiveLongBaseIterator(){
            private final NodeStore store;
            private long highId;
            private long currentId;
            private final NodeRecord reusableNodeRecord;
            {
                this.store = DiskLayer.this.neoStore.getNodeStore();
                this.highId = this.store.getHighestPossibleIdInUse();
                this.reusableNodeRecord = new NodeRecord(-1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            protected boolean fetchNext() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            record = this.store.loadRecord(this.currentId, this.reusableNodeRecord);
                            if (record == null || !record.inUse()) ** GOTO lbl-1000
                            var2_3 = this.next(record.getId());
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = this.store.getHighestPossibleIdInUse();
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return false;
            }
        };
    }

    @Override
    public RelationshipIterator relationshipsGetAll() {
        return new RelationshipIterator.BaseIterator(){
            private final RelationshipStore store;
            private long highId;
            private long currentId;
            private final RelationshipRecord reusableRecord;
            {
                this.store = DiskLayer.this.neoStore.getRelationshipStore();
                this.highId = this.store.getHighestPossibleIdInUse();
                this.reusableRecord = new RelationshipRecord(-1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            protected boolean fetchNext() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            if (!this.store.fillRecord(this.currentId, this.reusableRecord, RecordLoad.CHECK) || !this.reusableRecord.inUse()) ** GOTO lbl-1000
                            var1_2 = this.next(this.reusableRecord.getId());
                            return var1_2;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = this.store.getHighestPossibleIdInUse();
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return false;
            }

            @Override
            public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
                visitor.visit(relationshipId, this.reusableRecord.getType(), this.reusableRecord.getFirstNode(), this.reusableRecord.getSecondNode());
                return false;
            }
        };
    }

    @Override
    public long reserveNode() {
        return this.nodeStore.nextId();
    }

    @Override
    public long reserveRelationship() {
        return this.relationshipStore.nextId();
    }

    @Override
    public void releaseNode(long id) {
        this.nodeStore.freeId(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.relationshipStore.freeId(id);
    }

    @Override
    public Cursor expand(Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> types, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long countsForNode(int labelId) {
        return this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
    }

    private static class PropertyStoreProvider
    implements Provider<PropertyStore> {
        private final Supplier<NeoStore> neoStoreProvider;

        public PropertyStoreProvider(Supplier<NeoStore> neoStoreProvider) {
            this.neoStoreProvider = neoStoreProvider;
        }

        @Override
        public PropertyStore instance() {
            return ((NeoStore)this.neoStoreProvider.get()).getPropertyStore();
        }
    }
}

