/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.function.primitive.PrimitiveIntPredicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class StoreRelationshipIterable
implements PrimitiveLongIterable {
    private final NeoStore neoStore;
    private final NodeRecord node;
    private final PrimitiveIntPredicate type;
    private final Direction direction;
    private static final GroupChain[] GROUP_CHAINS = GroupChain.values();

    public StoreRelationshipIterable(NeoStore neoStore, long nodeId, PrimitiveIntPredicate type, Direction direction) throws EntityNotFoundException {
        this.neoStore = neoStore;
        this.type = type;
        this.direction = direction;
        this.node = StoreRelationshipIterable.nodeRecord(neoStore, nodeId);
    }

    public static RelationshipIterator iterator(NeoStore neoStore, long nodeId, PrimitiveIntPredicate type, Direction direction) throws EntityNotFoundException {
        NodeRecord node = StoreRelationshipIterable.nodeRecord(neoStore, nodeId);
        return StoreRelationshipIterable.iterator(neoStore, node, type, direction);
    }

    private static NodeRecord nodeRecord(NeoStore neoStore, long nodeId) throws EntityNotFoundException {
        NodeRecord node = neoStore.getNodeStore().loadRecord(nodeId, null);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        return node;
    }

    public static RelationshipIterator iterator(NeoStore neoStore, NodeRecord node, PrimitiveIntPredicate type, Direction direction) {
        RelationshipGroupStore groupStore = neoStore.getRelationshipGroupStore();
        RelationshipStore relationshipStore = neoStore.getRelationshipStore();
        if (node.isDense()) {
            return new DenseIterator(node, groupStore, relationshipStore, type, direction);
        }
        return new SparseIterator(node, relationshipStore, type, direction);
    }

    private static long followRelationshipChain(long nodeId, RelationshipRecord relRecord) {
        if (relRecord.getFirstNode() == nodeId) {
            return relRecord.getFirstNextRel();
        }
        if (relRecord.getSecondNode() == nodeId) {
            return relRecord.getSecondNextRel();
        }
        throw new InvalidRecordException("While loading relationships for Node[" + nodeId + "] a Relationship[" + relRecord.getId() + "] was encountered that had startNode: " + relRecord.getFirstNode() + " and endNode: " + relRecord.getSecondNode() + ", i.e. which had neither start nor end node as the node we're loading relationships for");
    }

    public RelationshipIterator iterator() {
        return StoreRelationshipIterable.iterator(this.neoStore, this.node, this.type, this.direction);
    }

    private static enum GroupChain {
        OUT{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstOut();
            }

            @Override
            boolean matchesDirection(Direction direction) {
                return direction == Direction.OUTGOING;
            }
        }
        ,
        IN{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstIn();
            }

            @Override
            boolean matchesDirection(Direction direction) {
                return direction == Direction.INCOMING;
            }
        }
        ,
        LOOP{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstLoop();
            }

            @Override
            boolean matchesDirection(Direction direction) {
                return true;
            }
        };


        abstract long chainStart(RelationshipGroupRecord var1);

        abstract boolean matchesDirection(Direction var1);
    }

    private static class DenseIterator
    extends StoreRelationshipIterator {
        private final long nodeId;
        private final RelationshipGroupStore groupStore;
        private RelationshipGroupRecord groupRecord;
        private int groupChainIndex;
        private long nextRelId;

        DenseIterator(NodeRecord nodeRecord, RelationshipGroupStore groupStore, RelationshipStore relationshipStore, PrimitiveIntPredicate type, Direction direction) {
            super(relationshipStore, type, direction);
            this.groupStore = groupStore;
            this.nodeId = nodeRecord.getId();
            this.groupRecord = groupStore.getRecord(nodeRecord.getNextRel());
            this.nextRelId = this.nextChainStart();
        }

        private long nextChainStart() {
            while (this.groupRecord != null) {
                if (this.type.accept(this.groupRecord.getType())) {
                    while (this.groupChainIndex < GROUP_CHAINS.length) {
                        GroupChain groupChain = GROUP_CHAINS[this.groupChainIndex++];
                        long chainStart = groupChain.chainStart(this.groupRecord);
                        if (chainStart == (long)Record.NO_NEXT_RELATIONSHIP.intValue() || this.direction != Direction.BOTH && !groupChain.matchesDirection(this.direction)) continue;
                        return chainStart;
                    }
                }
                this.groupRecord = this.groupRecord.getNext() != (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? this.groupStore.getRecord(this.groupRecord.getNext()) : null;
                this.groupChainIndex = 0;
            }
            return Record.NO_NEXT_RELATIONSHIP.intValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean fetchNext() {
            if (this.nextRelId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                this.relationshipStore.fillRecord(this.nextRelId, this.relationship, RecordLoad.NORMAL);
                try {
                    boolean bl = this.next(this.nextRelId);
                    return bl;
                }
                finally {
                    this.nextRelId = StoreRelationshipIterable.followRelationshipChain(this.nodeId, this.relationship);
                    if (this.nextRelId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                        this.nextRelId = this.nextChainStart();
                    }
                }
            }
            return false;
        }
    }

    private static class SparseIterator
    extends StoreRelationshipIterator {
        private final long nodeId;
        private long nextRelId;

        SparseIterator(NodeRecord nodeRecord, RelationshipStore relationshipStore, PrimitiveIntPredicate type, Direction direction) {
            super(relationshipStore, type, direction);
            this.nodeId = nodeRecord.getId();
            this.nextRelId = nodeRecord.getNextRel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean fetchNext() {
            while (this.nextRelId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                this.relationshipStore.fillRecord(this.nextRelId, this.relationship, RecordLoad.NORMAL);
                try {
                    if (!this.type.accept(this.relationship.getType()) || !this.directionMatches(this.nodeId, this.relationship)) continue;
                    boolean bl = this.next(this.nextRelId);
                    return bl;
                }
                finally {
                    this.nextRelId = StoreRelationshipIterable.followRelationshipChain(this.nodeId, this.relationship);
                }
            }
            return false;
        }
    }

    public static abstract class StoreRelationshipIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator
    implements RelationshipIterator {
        protected final RelationshipStore relationshipStore;
        protected final PrimitiveIntPredicate type;
        protected final Direction direction;
        protected final RelationshipRecord relationship = new RelationshipRecord(-1L);

        private StoreRelationshipIterator(RelationshipStore relationshipStore, PrimitiveIntPredicate type, Direction direction) {
            this.relationshipStore = relationshipStore;
            this.type = type;
            this.direction = direction;
        }

        @Override
        public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
            visitor.visit(this.relationship.getId(), this.relationship.getType(), this.relationship.getFirstNode(), this.relationship.getSecondNode());
            return false;
        }

        protected boolean directionMatches(long nodeId, RelationshipRecord relationship) {
            switch (this.direction) {
                case BOTH: {
                    return true;
                }
                case OUTGOING: {
                    return relationship.getFirstNode() == nodeId;
                }
                case INCOMING: {
                    return relationship.getSecondNode() == nodeId;
                }
            }
            throw new IllegalArgumentException("Unknown direction " + (Object)((Object)this.direction));
        }
    }
}

