/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collections;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.register.Register;

public interface IndexReader
extends Resource {
    public static final IndexReader EMPTY = new IndexReader(){

        @Override
        public PrimitiveLongIterator lookup(Object value) {
            return PrimitiveLongCollections.emptyIterator();
        }

        @Override
        public PrimitiveLongIterator scan() {
            return PrimitiveLongCollections.emptyIterator();
        }

        @Override
        public int getIndexedCount(long nodeId, Object propertyValue) {
            return 0;
        }

        @Override
        public Set<Class> valueTypesInIndex() {
            return Collections.emptySet();
        }

        @Override
        public long sampleIndex(Register.DoubleLong.Out result) {
            result.write(0L, 0L);
            return 0L;
        }

        @Override
        public void close() {
        }
    };

    public PrimitiveLongIterator lookup(Object var1);

    public PrimitiveLongIterator scan();

    public int getIndexedCount(long var1, Object var3);

    public Set<Class> valueTypesInIndex();

    public long sampleIndex(Register.DoubleLong.Out var1) throws IndexNotFoundKernelException;

    public static class Delegator
    implements IndexReader {
        private final IndexReader delegate;

        public Delegator(IndexReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public PrimitiveLongIterator lookup(Object value) {
            return this.delegate.lookup(value);
        }

        @Override
        public PrimitiveLongIterator scan() {
            return this.delegate.scan();
        }

        @Override
        public int getIndexedCount(long nodeId, Object propertyValue) {
            return this.delegate.getIndexedCount(nodeId, propertyValue);
        }

        @Override
        public Set<Class> valueTypesInIndex() {
            return this.delegate.valueTypesInIndex();
        }

        @Override
        public long sampleIndex(Register.DoubleLong.Out result) throws IndexNotFoundKernelException {
            return this.delegate.sampleIndex(result);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

