/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogRotationImpl
implements LogRotation {
    private final LogRotation.Monitor monitor;
    private final LogFile logFile;
    private final LogRotationControl logRotationControl;
    private final KernelHealth kernelHealth;
    private final Log msgLog;

    public LogRotationImpl(LogRotation.Monitor monitor, LogFile logFile, LogRotationControl logRotationControl, KernelHealth kernelHealth, LogProvider logProvider) {
        this.monitor = monitor;
        this.logFile = logFile;
        this.logRotationControl = logRotationControl;
        this.kernelHealth = kernelHealth;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rotateLogIfNeeded(LogAppendEvent logAppendEvent) throws IOException {
        if (this.logFile.rotationNeeded()) {
            boolean rotated;
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                rotated = this.logFile.rotationNeeded();
                if (rotated) {
                    try (LogRotateEvent rotateEvent = logAppendEvent.beginLogRotate();){
                        this.doRotate();
                    }
                }
            }
            return rotated;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateLogFile() throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.doRotate();
        }
    }

    private void doRotate() throws IOException {
        long currentVersion = this.logFile.currentLogVersion();
        this.monitor.startedRotating(currentVersion);
        this.kernelHealth.assertHealthy(IOException.class);
        this.msgLog.info(LogRotation.PrintFormat.prefix(currentVersion) + " Awaiting all transactions closed...");
        this.logRotationControl.awaitAllTransactionsClosed();
        this.msgLog.info(LogRotation.PrintFormat.prefix(currentVersion) + " Starting store flush...");
        this.logRotationControl.forceEverything();
        this.kernelHealth.assertHealthy(IOException.class);
        this.msgLog.info(LogRotation.PrintFormat.prefix(currentVersion) + " Preparing new log file...");
        this.logFile.rotate();
        this.monitor.finishedRotating(currentVersion);
    }
}

