/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.logging.Logger;

@Deprecated
abstract class KernelDiagnostics
implements DiagnosticsProvider {
    KernelDiagnostics() {
    }

    static void register(DiagnosticsManager manager, InternalAbstractGraphDatabase graphdb, NeoStoreDataSource ds) {
        manager.prependProvider(new Versions(graphdb.getClass(), ds));
        ds.registerDiagnosticsWith(manager);
        manager.appendProvider(new StoreFiles(graphdb.getStoreDir()));
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getDeclaringClass().getSimpleName() + ":" + this.getClass().getSimpleName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            this.dump(log);
        }
    }

    abstract void dump(Logger var1);

    private static class StoreFiles
    extends KernelDiagnostics {
        private final File storeDir;
        private static String FORMAT_DATE_ISO = "yyyy-MM-dd'T'HH:mm:ssZ";
        private final SimpleDateFormat dateFormat;

        private StoreFiles(String storeDir) {
            this.storeDir = new File(storeDir);
            TimeZone tz = TimeZone.getDefault();
            this.dateFormat = new SimpleDateFormat(FORMAT_DATE_ISO);
            this.dateFormat.setTimeZone(tz);
        }

        @Override
        void dump(Logger logger) {
            logger.log(this.getDiskSpace(this.storeDir) + "\nStorage files: (filename : modification date - size)");
            this.logStoreFiles(logger, "  ", this.storeDir);
        }

        private long logStoreFiles(Logger logger, String prefix, File dir) {
            if (!dir.isDirectory()) {
                return 0L;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                logger.log(prefix + "<INACCESSIBLE>");
                return 0L;
            }
            long total = 0L;
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (File file : fileList) {
                long size;
                String filename = file.getName();
                if (file.isDirectory()) {
                    logger.log(prefix + filename + ":");
                    size = this.logStoreFiles(logger, prefix + "  ", file);
                    filename = "- Total";
                } else {
                    size = file.length();
                }
                String fileModificationDate = this.getFileModificationDate(file);
                String bytes = Format.bytes(size);
                String fileInformation = String.format("%s%s: %s - %s", prefix, filename, fileModificationDate, bytes);
                logger.log(fileInformation);
                total += size;
            }
            return total;
        }

        private String getFileModificationDate(File file) {
            Date modifiedDate = new Date(file.lastModified());
            return this.dateFormat.format(modifiedDate);
        }

        private String getDiskSpace(File storeDir) {
            long free = storeDir.getFreeSpace();
            long total = storeDir.getTotalSpace();
            long percentage = total != 0L ? free * 100L / total : 0L;
            return String.format("Disk space on partition (Total / Free / Free %%): %s / %s / %s", total, free, percentage);
        }
    }

    private static class Versions
    extends KernelDiagnostics {
        private final Class<? extends GraphDatabaseService> graphDb;
        private final StoreId storeId;

        public Versions(Class<? extends GraphDatabaseService> graphDb, NeoStoreDataSource ds) {
            this.graphDb = graphDb;
            this.storeId = ds.getStoreId();
        }

        @Override
        void dump(Logger logger) {
            logger.log("Graph Database: " + this.graphDb.getName() + " " + this.storeId);
            logger.log("Kernel version: " + Version.getKernel());
            logger.log("Neo4j component versions:");
            for (Version componentVersion : Service.load(Version.class)) {
                logger.log("  " + componentVersion + "; revision: " + componentVersion.getRevision());
            }
        }
    }
}

